/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle.monitors;

import com.codahale.metrics.health.HealthCheck;
import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.core.healthservice.TimeEntity;
import io.appform.ranger.core.healthservice.monitor.IsolatedHealthMonitor;
import io.dropwizard.core.setup.Environment;

public class DropwizardHealthMonitor
extends IsolatedHealthMonitor<HealthcheckStatus> {
    private final Environment environment;

    public DropwizardHealthMonitor(TimeEntity runInterval, long stalenessAllowedInMillis, Environment environment) {
        super("dropwizard-health-monitor", runInterval, stalenessAllowedInMillis);
        this.environment = environment;
    }

    public HealthcheckStatus monitor() {
        return null != this.environment.healthChecks() && this.environment.healthChecks().runHealthChecks().values().stream().allMatch(HealthCheck.Result::isHealthy) ? HealthcheckStatus.healthy : HealthcheckStatus.unhealthy;
    }
}

