/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle.id.constraints.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.discovery.bundle.id.Id;
import io.appform.ranger.discovery.bundle.id.constraints.IdValidationConstraint;
import io.appform.ranger.discovery.bundle.id.constraints.impl.KeyPartitioner;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionValidator
implements IdValidationConstraint {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PartitionValidator.class);
    private final int partition;
    private final KeyPartitioner partitioner;

    public PartitionValidator(int partition, KeyPartitioner partitioner) {
        Preconditions.checkArgument((partition > 0 ? 1 : 0) != 0, (Object)"Provide a non-negative and non-zero partition count");
        Preconditions.checkArgument((partitioner != null ? 1 : 0) != 0, (Object)"Provide a non null key partitioner");
        this.partition = partition;
        this.partitioner = partitioner;
    }

    @Override
    public boolean isValid(Id id) {
        return this.partition == this.partitioner.partition(id);
    }
}

