/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle.id;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.discovery.bundle.id.CuratorPathUtils;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIdManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NodeIdManager.class);
    private final CuratorFramework curatorFramework;
    private final SecureRandom secureRandom;
    private final CuratorPathUtils pathUtils;
    private int node;

    public NodeIdManager(CuratorFramework curatorFramework, String processName) {
        this.curatorFramework = curatorFramework;
        this.secureRandom = new SecureRandom(Long.toBinaryString(System.currentTimeMillis()).getBytes());
        this.pathUtils = new CuratorPathUtils(processName);
    }

    public int fixNodeId() {
        try {
            log.info("Waiting for curator to start");
            this.curatorFramework.blockUntilConnected();
            log.info("Curator started");
        }
        catch (InterruptedException e) {
            log.error("Wait for curator start interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        Retryer retryer = RetryerBuilder.newBuilder().retryIfResult(aBoolean -> Objects.equals(aBoolean, false)).retryIfException().withStopStrategy(StopStrategies.neverStop()).build();
        try {
            retryer.call(() -> {
                this.node = this.secureRandom.nextInt(10000);
                String path = this.pathUtils.path(this.node);
                try {
                    ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path);
                }
                catch (KeeperException.NodeExistsException e) {
                    log.warn("Collision on node {}, will retry with new node.", (Object)this.node);
                    return false;
                }
                log.info("Node will be set to node id {}", (Object)this.node);
                return true;
            });
        }
        catch (RetryException e) {
            log.error("Error creating node", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("Execution exception while creating node", (Throwable)e);
        }
        return this.node;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getNode() {
        return this.node;
    }
}

