/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle.id;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.discovery.bundle.id.CollisionChecker;
import io.appform.ranger.discovery.bundle.id.constraints.IdValidationConstraint;
import io.appform.ranger.discovery.bundle.id.formatter.DefaultIdFormatter;
import io.appform.ranger.discovery.bundle.id.formatter.IdFormatter;
import io.appform.ranger.discovery.bundle.id.formatter.IdFormatters;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;

public class Domain {
    public static final String DEFAULT_DOMAIN_NAME = "__DEFAULT_DOMAIN__";
    public static final Domain DEFAULT = new Domain("__DEFAULT_DOMAIN__", List.of(), new DefaultIdFormatter(), TimeUnit.MILLISECONDS);
    private final String domain;
    private final List<IdValidationConstraint> constraints;
    private final IdFormatter idFormatter;
    private final CollisionChecker collisionChecker;

    public Domain(@NonNull String domain, @NonNull List<IdValidationConstraint> constraints, IdFormatter idFormatter, TimeUnit resolution) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        if (constraints == null) {
            throw new NullPointerException("constraints is marked non-null but is null");
        }
        this.domain = domain;
        this.constraints = constraints;
        this.idFormatter = Objects.requireNonNullElse(idFormatter, IdFormatters.original());
        this.collisionChecker = new CollisionChecker(Objects.requireNonNullElse(resolution, TimeUnit.MILLISECONDS));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static DomainBuilder builder() {
        return new DomainBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDomain() {
        return this.domain;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<IdValidationConstraint> getConstraints() {
        return this.constraints;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IdFormatter getIdFormatter() {
        return this.idFormatter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CollisionChecker getCollisionChecker() {
        return this.collisionChecker;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class DomainBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String domain;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<IdValidationConstraint> constraints;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private IdFormatter idFormatter;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private TimeUnit resolution;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        DomainBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DomainBuilder domain(@NonNull String domain) {
            if (domain == null) {
                throw new NullPointerException("domain is marked non-null but is null");
            }
            this.domain = domain;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DomainBuilder constraints(@NonNull List<IdValidationConstraint> constraints) {
            if (constraints == null) {
                throw new NullPointerException("constraints is marked non-null but is null");
            }
            this.constraints = constraints;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DomainBuilder idFormatter(IdFormatter idFormatter) {
            this.idFormatter = idFormatter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DomainBuilder resolution(TimeUnit resolution) {
            this.resolution = resolution;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Domain build() {
            return new Domain(this.domain, this.constraints, this.idFormatter, this.resolution);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Domain.DomainBuilder(domain=" + this.domain + ", constraints=" + this.constraints + ", idFormatter=" + this.idFormatter + ", resolution=" + this.resolution + ")";
        }
    }
}

