/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle.id;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.BitSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollisionChecker {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CollisionChecker.class);
    private final BitSet bitSet = new BitSet(1000);
    private long currentInstant = 0L;
    private final Lock dataLock = new ReentrantLock();
    private final TimeUnit resolution;

    public CollisionChecker() {
        this(TimeUnit.MILLISECONDS);
    }

    public CollisionChecker(@NonNull TimeUnit resolution) {
        if (resolution == null) {
            throw new NullPointerException("resolution is marked non-null but is null");
        }
        this.resolution = resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(long timeInMillis, int location) {
        this.dataLock.lock();
        try {
            long resolvedTime = this.resolution.convert(timeInMillis, TimeUnit.MILLISECONDS);
            if (this.currentInstant != resolvedTime) {
                this.currentInstant = resolvedTime;
                this.bitSet.clear();
            }
            if (this.bitSet.get(location)) {
                boolean bl = false;
                return bl;
            }
            this.bitSet.set(location);
            boolean bl = true;
            return bl;
        }
        finally {
            this.dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(long time, int location) {
        this.dataLock.lock();
        try {
            if (this.currentInstant != time) {
                return;
            }
            this.bitSet.clear(location);
        }
        finally {
            this.dataLock.unlock();
        }
    }
}

