/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Set;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class ServiceDiscoveryConfiguration {
    @NotNull
    @NotEmpty
    private String namespace = "default";
    @NotNull
    @NotEmpty
    private String environment;
    @NotNull
    @NotEmpty
    private String zookeeper;
    @Min(value=1000L)
    @Max(value=60000L)
    private @Min(value=1000L) @Max(value=60000L) int connectionRetryIntervalMillis = 5000;
    @NotNull
    @NotEmpty
    private String publishedHost = "__DEFAULT_SERVICE_HOST";
    @NotNull
    @Min(value=-1L)
    @Max(value=65535L)
    private @NotNull @Min(value=-1L) @Max(value=65535L) int publishedPort = -1;
    private int refreshTimeMs;
    private boolean disableWatchers;
    @Min(value=0L)
    @Max(value=600L)
    private @Min(value=0L) @Max(value=600L) long initialDelaySeconds;
    private boolean initialRotationStatus = true;
    private int dropwizardCheckInterval = 15;
    private int dropwizardCheckStaleness;
    private Set<String> tags;

    public ServiceDiscoveryConfiguration(String namespace, String environment, String zookeeper, int connectionRetryIntervalMillis, String publishedHost, int publishedPort, int refreshTimeMs, boolean disableWatchers, long initialDelaySeconds, boolean initialRotationStatus, int dropwizardCheckInterval, int dropwizardCheckStaleness, Set<String> tags) {
        this.namespace = Strings.isNullOrEmpty((String)namespace) ? "default" : namespace;
        this.environment = environment;
        this.zookeeper = zookeeper;
        this.connectionRetryIntervalMillis = connectionRetryIntervalMillis == 0 ? 5000 : connectionRetryIntervalMillis;
        this.publishedHost = Strings.isNullOrEmpty((String)publishedHost) ? "__DEFAULT_SERVICE_HOST" : publishedHost;
        this.publishedPort = publishedPort == 0 ? -1 : publishedPort;
        this.refreshTimeMs = refreshTimeMs;
        this.disableWatchers = disableWatchers;
        this.initialDelaySeconds = initialDelaySeconds;
        this.initialRotationStatus = initialRotationStatus;
        this.dropwizardCheckInterval = dropwizardCheckInterval == 0 ? 15 : dropwizardCheckInterval;
        this.dropwizardCheckStaleness = dropwizardCheckStaleness;
        this.tags = tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ServiceDiscoveryConfigurationBuilder builder() {
        return new ServiceDiscoveryConfigurationBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getZookeeper() {
        return this.zookeeper;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getConnectionRetryIntervalMillis() {
        return this.connectionRetryIntervalMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPublishedHost() {
        return this.publishedHost;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPublishedPort() {
        return this.publishedPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRefreshTimeMs() {
        return this.refreshTimeMs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDisableWatchers() {
        return this.disableWatchers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getInitialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isInitialRotationStatus() {
        return this.initialRotationStatus;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getDropwizardCheckInterval() {
        return this.dropwizardCheckInterval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getDropwizardCheckStaleness() {
        return this.dropwizardCheckStaleness;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setZookeeper(String zookeeper) {
        this.zookeeper = zookeeper;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConnectionRetryIntervalMillis(int connectionRetryIntervalMillis) {
        this.connectionRetryIntervalMillis = connectionRetryIntervalMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPublishedHost(String publishedHost) {
        this.publishedHost = publishedHost;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPublishedPort(int publishedPort) {
        this.publishedPort = publishedPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRefreshTimeMs(int refreshTimeMs) {
        this.refreshTimeMs = refreshTimeMs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDisableWatchers(boolean disableWatchers) {
        this.disableWatchers = disableWatchers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setInitialDelaySeconds(long initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setInitialRotationStatus(boolean initialRotationStatus) {
        this.initialRotationStatus = initialRotationStatus;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDropwizardCheckInterval(int dropwizardCheckInterval) {
        this.dropwizardCheckInterval = dropwizardCheckInterval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDropwizardCheckStaleness(int dropwizardCheckStaleness) {
        this.dropwizardCheckStaleness = dropwizardCheckStaleness;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceDiscoveryConfiguration)) {
            return false;
        }
        ServiceDiscoveryConfiguration other = (ServiceDiscoveryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectionRetryIntervalMillis() != other.getConnectionRetryIntervalMillis()) {
            return false;
        }
        if (this.getPublishedPort() != other.getPublishedPort()) {
            return false;
        }
        if (this.getRefreshTimeMs() != other.getRefreshTimeMs()) {
            return false;
        }
        if (this.isDisableWatchers() != other.isDisableWatchers()) {
            return false;
        }
        if (this.getInitialDelaySeconds() != other.getInitialDelaySeconds()) {
            return false;
        }
        if (this.isInitialRotationStatus() != other.isInitialRotationStatus()) {
            return false;
        }
        if (this.getDropwizardCheckInterval() != other.getDropwizardCheckInterval()) {
            return false;
        }
        if (this.getDropwizardCheckStaleness() != other.getDropwizardCheckStaleness()) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$zookeeper = this.getZookeeper();
        String other$zookeeper = other.getZookeeper();
        if (this$zookeeper == null ? other$zookeeper != null : !this$zookeeper.equals(other$zookeeper)) {
            return false;
        }
        String this$publishedHost = this.getPublishedHost();
        String other$publishedHost = other.getPublishedHost();
        if (this$publishedHost == null ? other$publishedHost != null : !this$publishedHost.equals(other$publishedHost)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceDiscoveryConfiguration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectionRetryIntervalMillis();
        result = result * 59 + this.getPublishedPort();
        result = result * 59 + this.getRefreshTimeMs();
        result = result * 59 + (this.isDisableWatchers() ? 79 : 97);
        long $initialDelaySeconds = this.getInitialDelaySeconds();
        result = result * 59 + (int)($initialDelaySeconds >>> 32 ^ $initialDelaySeconds);
        result = result * 59 + (this.isInitialRotationStatus() ? 79 : 97);
        result = result * 59 + this.getDropwizardCheckInterval();
        result = result * 59 + this.getDropwizardCheckStaleness();
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $zookeeper = this.getZookeeper();
        result = result * 59 + ($zookeeper == null ? 43 : $zookeeper.hashCode());
        String $publishedHost = this.getPublishedHost();
        result = result * 59 + ($publishedHost == null ? 43 : $publishedHost.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ServiceDiscoveryConfiguration(namespace=" + this.getNamespace() + ", environment=" + this.getEnvironment() + ", zookeeper=" + this.getZookeeper() + ", connectionRetryIntervalMillis=" + this.getConnectionRetryIntervalMillis() + ", publishedHost=" + this.getPublishedHost() + ", publishedPort=" + this.getPublishedPort() + ", refreshTimeMs=" + this.getRefreshTimeMs() + ", disableWatchers=" + this.isDisableWatchers() + ", initialDelaySeconds=" + this.getInitialDelaySeconds() + ", initialRotationStatus=" + this.isInitialRotationStatus() + ", dropwizardCheckInterval=" + this.getDropwizardCheckInterval() + ", dropwizardCheckStaleness=" + this.getDropwizardCheckStaleness() + ", tags=" + this.getTags() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ServiceDiscoveryConfiguration() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ServiceDiscoveryConfigurationBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String namespace;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String environment;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String zookeeper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int connectionRetryIntervalMillis;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String publishedHost;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int publishedPort;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int refreshTimeMs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean disableWatchers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long initialDelaySeconds;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean initialRotationStatus;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int dropwizardCheckInterval;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int dropwizardCheckStaleness;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Set<String> tags;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ServiceDiscoveryConfigurationBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder zookeeper(String zookeeper) {
            this.zookeeper = zookeeper;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder connectionRetryIntervalMillis(int connectionRetryIntervalMillis) {
            this.connectionRetryIntervalMillis = connectionRetryIntervalMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder publishedHost(String publishedHost) {
            this.publishedHost = publishedHost;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder publishedPort(int publishedPort) {
            this.publishedPort = publishedPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder refreshTimeMs(int refreshTimeMs) {
            this.refreshTimeMs = refreshTimeMs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder initialDelaySeconds(long initialDelaySeconds) {
            this.initialDelaySeconds = initialDelaySeconds;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder initialRotationStatus(boolean initialRotationStatus) {
            this.initialRotationStatus = initialRotationStatus;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder dropwizardCheckInterval(int dropwizardCheckInterval) {
            this.dropwizardCheckInterval = dropwizardCheckInterval;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder dropwizardCheckStaleness(int dropwizardCheckStaleness) {
            this.dropwizardCheckStaleness = dropwizardCheckStaleness;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfigurationBuilder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryConfiguration build() {
            return new ServiceDiscoveryConfiguration(this.namespace, this.environment, this.zookeeper, this.connectionRetryIntervalMillis, this.publishedHost, this.publishedPort, this.refreshTimeMs, this.disableWatchers, this.initialDelaySeconds, this.initialRotationStatus, this.dropwizardCheckInterval, this.dropwizardCheckStaleness, this.tags);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ServiceDiscoveryConfiguration.ServiceDiscoveryConfigurationBuilder(namespace=" + this.namespace + ", environment=" + this.environment + ", zookeeper=" + this.zookeeper + ", connectionRetryIntervalMillis=" + this.connectionRetryIntervalMillis + ", publishedHost=" + this.publishedHost + ", publishedPort=" + this.publishedPort + ", refreshTimeMs=" + this.refreshTimeMs + ", disableWatchers=" + this.disableWatchers + ", initialDelaySeconds=" + this.initialDelaySeconds + ", initialRotationStatus=" + this.initialRotationStatus + ", dropwizardCheckInterval=" + this.dropwizardCheckInterval + ", dropwizardCheckStaleness=" + this.dropwizardCheckStaleness + ", tags=" + this.tags + ")";
        }
    }
}

