/*
 * Copyright (c) 2016 Santanu Sinha <santanu.sinha@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package io.appform.ranger.discovery.bundle.id;

/**
 * Utilities for curator
 */
public class CuratorPathUtils {
    private final String processName;

    public CuratorPathUtils(String processName) {
        this.processName = processName;
    }

    public String path(int nodeId) {
        return String.format("/%s/%s/%03d", "id-generator", processName, nodeId);
    }
}
