/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle.selectors;

import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.common.server.ShardInfo;
import io.appform.ranger.core.finder.serviceregistry.MapBasedServiceRegistry;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ShardSelector;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalEnvironmentAwareShardSelector
implements ShardSelector<ShardInfo, MapBasedServiceRegistry<ShardInfo>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HierarchicalEnvironmentAwareShardSelector.class);
    private static final String DEFAULT_SEPARATOR = ".";
    private static final Predicate<ShardInfo> DEFAULT_PREDICATE = shardInfo -> true;
    private final String environment;
    private final String separator;

    public HierarchicalEnvironmentAwareShardSelector(String environment) {
        this(environment, DEFAULT_SEPARATOR);
    }

    public HierarchicalEnvironmentAwareShardSelector(String environment, String separator) {
        this.environment = environment;
        this.separator = separator;
    }

    public List<ServiceNode<ShardInfo>> nodes(Predicate<ShardInfo> criteria, MapBasedServiceRegistry<ShardInfo> serviceRegistry) {
        ListMultimap serviceNodes = serviceRegistry.nodes();
        String serviceName = serviceRegistry.getService().getServiceName();
        Predicate<ShardInfo> evalPredicate = null != criteria ? criteria : DEFAULT_PREDICATE;
        for (IterableEnvironment env : new IterableEnvironment(this.environment, this.separator)) {
            List<ServiceNode<ShardInfo>> eligibleNodes = serviceNodes.entries().stream().filter(e -> ((ShardInfo)e.getKey()).getEnvironment().equals(env.environment) && evalPredicate.test((ShardInfo)e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            if (!eligibleNodes.isEmpty()) {
                log.debug("Effective environment for discovery of {} is {}", (Object)serviceName, (Object)env.environment);
                return eligibleNodes;
            }
            log.trace("No nodes found for environment: {}", (Object)env.environment);
        }
        log.warn("No valid nodes could be found for environment: {}", (Object)this.environment);
        return Collections.emptyList();
    }

    private static final class IterableEnvironment
    implements Iterable<IterableEnvironment> {
        private final String environment;
        private final String separator;

        private IterableEnvironment(String environment, String separator) {
            this.environment = environment;
            this.separator = separator;
        }

        @Override
        public Iterator<IterableEnvironment> iterator() {
            return new EnvironmentIterator(this.environment, this.separator);
        }

        public static final class EnvironmentIterator
        implements Iterator<IterableEnvironment> {
            private String remainingEnvironment;
            private final String separator;

            public EnvironmentIterator(String remainingEnvironment, String separator) {
                this.remainingEnvironment = remainingEnvironment;
                this.separator = separator;
            }

            @Override
            public boolean hasNext() {
                return !Strings.isNullOrEmpty((String)this.remainingEnvironment);
            }

            @Override
            public IterableEnvironment next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                log.debug("Effective environment for discovery is {}", (Object)this.remainingEnvironment);
                IterableEnvironment shardInfo = new IterableEnvironment(this.remainingEnvironment, this.separator);
                int sepIndex = this.remainingEnvironment.lastIndexOf(this.separator);
                this.remainingEnvironment = sepIndex < 0 ? "" : this.remainingEnvironment.substring(0, sepIndex);
                return shardInfo;
            }
        }
    }
}

