/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle.resolvers;

import io.appform.ranger.discovery.bundle.resolvers.PortSchemeResolver;
import io.dropwizard.Configuration;
import io.dropwizard.jetty.ConnectorFactory;
import io.dropwizard.jetty.HttpsConnectorFactory;
import io.dropwizard.server.DefaultServerFactory;
import io.dropwizard.server.ServerFactory;
import io.dropwizard.server.SimpleServerFactory;
import java.util.Optional;

public class DefaultPortSchemeResolver<T extends Configuration>
implements PortSchemeResolver<T> {
    @Override
    public String resolve(T configuration) {
        Optional<ConnectorFactory> connectionFactory = this.getConnectorFactory(configuration.getServerFactory());
        return connectionFactory.filter(HttpsConnectorFactory.class::isInstance).map(factory -> "https").orElse("http");
    }

    private Optional<ConnectorFactory> getConnectorFactory(ServerFactory serverFactory) {
        if (serverFactory instanceof DefaultServerFactory) {
            DefaultServerFactory defaultFactory = (DefaultServerFactory)serverFactory;
            return defaultFactory.getApplicationConnectors().stream().findFirst();
        }
        if (serverFactory instanceof SimpleServerFactory) {
            SimpleServerFactory defaultFactory = (SimpleServerFactory)serverFactory;
            return Optional.ofNullable(defaultFactory.getConnector());
        }
        return Optional.empty();
    }
}

