/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle.monitors;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.healthcheck.Healthcheck;
import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.discovery.bundle.rotationstatus.DropwizardServerStatus;
import io.dropwizard.setup.Environment;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardServerStartupCheck
implements Healthcheck {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DropwizardServerStartupCheck.class);
    private final DropwizardServerStatus serverStatus;

    public DropwizardServerStartupCheck(Environment environment, DropwizardServerStatus serverStatus) {
        this.serverStatus = serverStatus;
        environment.lifecycle().addServerLifecycleListener(server -> {
            log.info("Dropwizard server started. Marking healthcheck as healthy");
            serverStatus.markStarted();
        });
    }

    public HealthcheckStatus check() {
        return this.serverStatus.started() ? HealthcheckStatus.healthy : HealthcheckStatus.unhealthy;
    }
}

