/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle.id;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeExecutor;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.discovery.bundle.id.CollisionChecker;
import io.appform.ranger.discovery.bundle.id.Id;
import io.appform.ranger.discovery.bundle.id.constraints.IdValidationConstraint;
import io.appform.ranger.discovery.bundle.id.formatter.IdFormatter;
import io.appform.ranger.discovery.bundle.id.formatter.IdFormatters;
import io.appform.ranger.discovery.bundle.id.request.IdGenerationRequest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGenerator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdGenerator.class);
    private static final int MINIMUM_ID_LENGTH = 22;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom(Long.toBinaryString(System.currentTimeMillis()).getBytes());
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyMMddHHmmssSSS");
    private static final CollisionChecker COLLISION_CHECKER = new CollisionChecker();
    private static final RetryPolicy<GenerationResult> RETRY_POLICY = ((RetryPolicyBuilder)((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().withMaxAttempts(IdGenerator.readRetryCount()).handleIf(throwable -> true)).handleResultIf(Objects::isNull)).handleResultIf(generationResult -> generationResult.getState() == IdValidationState.INVALID_RETRYABLE)).onRetry(event -> {
        GenerationResult res = (GenerationResult)event.getLastResult();
        if (null != res && !res.getState().equals((Object)IdValidationState.VALID)) {
            Id id = res.getId();
            COLLISION_CHECKER.free(id.getGeneratedDate().getTime(), id.getExponent());
        }
    }).build();
    private static final FailsafeExecutor<GenerationResult> RETRIER = Failsafe.with(Collections.singletonList(RETRY_POLICY));
    private static final Pattern PATTERN = Pattern.compile("(.*)([0-9]{15})([0-9]{4})([0-9]{3})");
    private static final List<IdValidationConstraint> GLOBAL_CONSTRAINTS = new ArrayList<IdValidationConstraint>();
    private static final Map<String, List<IdValidationConstraint>> DOMAIN_SPECIFIC_CONSTRAINTS = new HashMap<String, List<IdValidationConstraint>>();
    private static int nodeId;

    public static void initialize(int node) {
        nodeId = node;
    }

    public static synchronized void cleanUp() {
        GLOBAL_CONSTRAINTS.clear();
        DOMAIN_SPECIFIC_CONSTRAINTS.clear();
    }

    public static synchronized void initialize(int node, List<IdValidationConstraint> globalConstraints, Map<String, List<IdValidationConstraint>> domainSpecificConstraints) {
        nodeId = node;
        if (null != globalConstraints) {
            GLOBAL_CONSTRAINTS.addAll(globalConstraints);
        }
        if (null != domainSpecificConstraints) {
            DOMAIN_SPECIFIC_CONSTRAINTS.putAll(domainSpecificConstraints);
        }
    }

    public static synchronized void registerGlobalConstraints(IdValidationConstraint ... constraints) {
        IdGenerator.registerGlobalConstraints((List<IdValidationConstraint>)ImmutableList.copyOf((Object[])constraints));
    }

    public static synchronized void registerGlobalConstraints(List<IdValidationConstraint> constraints) {
        Preconditions.checkArgument((null != constraints && !constraints.isEmpty() ? 1 : 0) != 0);
        GLOBAL_CONSTRAINTS.addAll(constraints);
    }

    public static synchronized void registerDomainSpecificConstraints(String domain, IdValidationConstraint ... validationConstraints) {
        IdGenerator.registerDomainSpecificConstraints(domain, (List<IdValidationConstraint>)ImmutableList.copyOf((Object[])validationConstraints));
    }

    public static synchronized void registerDomainSpecificConstraints(String domain, List<IdValidationConstraint> validationConstraints) {
        Preconditions.checkArgument((null != validationConstraints && !validationConstraints.isEmpty() ? 1 : 0) != 0);
        DOMAIN_SPECIFIC_CONSTRAINTS.computeIfAbsent(domain, key -> new ArrayList()).addAll(validationConstraints);
    }

    public static Id generate(String prefix) {
        return IdGenerator.generate(prefix, IdFormatters.original());
    }

    public static Id generate(String prefix, IdFormatter idFormatter) {
        IdInfo idInfo = IdGenerator.random();
        DateTime dateTime = new DateTime(idInfo.time);
        String id = String.format("%s%s", prefix, idFormatter.format(dateTime, nodeId, idInfo.exponent));
        return Id.builder().id(id).exponent(idInfo.exponent).generatedDate(dateTime.toDate()).node(nodeId).build();
    }

    public static Optional<Id> generateWithConstraints(String prefix, String domain) {
        return IdGenerator.generateWithConstraints(prefix, DOMAIN_SPECIFIC_CONSTRAINTS.getOrDefault(domain, Collections.emptyList()), true);
    }

    public static Optional<Id> generateWithConstraints(String prefix, String domain, boolean skipGlobal) {
        return IdGenerator.generateWithConstraints(prefix, DOMAIN_SPECIFIC_CONSTRAINTS.getOrDefault(domain, Collections.emptyList()), skipGlobal);
    }

    public static Optional<Id> generateWithConstraints(String prefix, List<IdValidationConstraint> inConstraints) {
        return IdGenerator.generateWithConstraints(prefix, inConstraints, false);
    }

    public static Optional<Id> parse(String idString) {
        if (idString == null || idString.length() < 22) {
            return Optional.empty();
        }
        try {
            Matcher matcher = PATTERN.matcher(idString);
            if (matcher.find()) {
                return Optional.of(Id.builder().id(idString).node(Integer.parseInt(matcher.group(3))).exponent(Integer.parseInt(matcher.group(4))).generatedDate(DATE_TIME_FORMATTER.parseDateTime(matcher.group(2)).toDate()).build());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            log.warn("Could not parse idString {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static Optional<Id> generateWithConstraints(String prefix, List<IdValidationConstraint> inConstraints, boolean skipGlobal) {
        return IdGenerator.generate(IdGenerationRequest.builder().prefix(prefix).constraints(inConstraints).skipGlobal(skipGlobal).idFormatter(IdFormatters.original()).build());
    }

    public static Optional<Id> generate(IdGenerationRequest request) {
        return Optional.ofNullable((GenerationResult)RETRIER.get(() -> {
            Id id = IdGenerator.generate(request.getPrefix(), request.getIdFormatter());
            return new GenerationResult(id, IdGenerator.validateId(request.getConstraints(), id, request.isSkipGlobal()));
        })).filter(generationResult -> generationResult.getState() == IdValidationState.VALID).map(GenerationResult::getId);
    }

    private static IdInfo random() {
        int randomGen;
        long time;
        while (!COLLISION_CHECKER.check(time = System.currentTimeMillis(), randomGen = SECURE_RANDOM.nextInt(1000))) {
        }
        return new IdInfo(randomGen, time);
    }

    private static IdValidationState validateId(List<IdValidationConstraint> inConstraints, Id id, boolean skipGlobal) {
        IdValidationConstraint failedLocalConstraint;
        IdValidationConstraint failedGlobalConstraint;
        IdValidationConstraint idValidationConstraint = failedGlobalConstraint = skipGlobal ? null : (IdValidationConstraint)GLOBAL_CONSTRAINTS.stream().filter(constraint -> !constraint.isValid(id)).findFirst().orElse(null);
        if (null != failedGlobalConstraint) {
            return failedGlobalConstraint.failFast() ? IdValidationState.INVALID_NON_RETRYABLE : IdValidationState.INVALID_RETRYABLE;
        }
        IdValidationConstraint idValidationConstraint2 = failedLocalConstraint = null == inConstraints ? null : (IdValidationConstraint)inConstraints.stream().filter(constraint -> !constraint.isValid(id)).findFirst().orElse(null);
        if (null != failedLocalConstraint) {
            return failedLocalConstraint.failFast() ? IdValidationState.INVALID_NON_RETRYABLE : IdValidationState.INVALID_RETRYABLE;
        }
        return IdValidationState.VALID;
    }

    private static int readRetryCount() {
        try {
            int count = Integer.parseInt(System.getenv().getOrDefault("NUM_ID_GENERATION_RETRIES", "512"));
            if (count <= 0) {
                throw new IllegalArgumentException("Negative number of retries does not make sense. Please set a proper value for NUM_ID_GENERATION_RETRIES");
            }
            return count;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Please provide a valid positive integer for NUM_ID_GENERATION_RETRIES");
        }
    }

    private static final class IdInfo {
        private final int exponent;
        private final long time;

        public IdInfo(int exponent, long time) {
            this.exponent = exponent;
            this.time = time;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getExponent() {
            return this.exponent;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getTime() {
            return this.time;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdInfo)) {
                return false;
            }
            IdInfo other = (IdInfo)o;
            if (this.getExponent() != other.getExponent()) {
                return false;
            }
            return this.getTime() == other.getTime();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExponent();
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "IdGenerator.IdInfo(exponent=" + this.getExponent() + ", time=" + this.getTime() + ")";
        }
    }

    private static final class GenerationResult {
        private final Id id;
        private final IdValidationState state;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenerationResult(Id id, IdValidationState state) {
            this.id = id;
            this.state = state;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Id getId() {
            return this.id;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public IdValidationState getState() {
            return this.state;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenerationResult)) {
                return false;
            }
            GenerationResult other = (GenerationResult)o;
            Id this$id = this.getId();
            Id other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            IdValidationState this$state = this.getState();
            IdValidationState other$state = other.getState();
            return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Id $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            IdValidationState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "IdGenerator.GenerationResult(id=" + this.getId() + ", state=" + this.getState() + ")";
        }
    }

    private static enum IdValidationState {
        VALID,
        INVALID_RETRYABLE,
        INVALID_NON_RETRYABLE;

    }
}

