/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.discovery.bundle;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.RangerClient;
import io.appform.ranger.client.zk.SimpleRangerZKClient;
import io.appform.ranger.common.server.ShardInfo;
import io.appform.ranger.core.finder.serviceregistry.MapBasedServiceRegistry;
import io.appform.ranger.core.healthcheck.Healthcheck;
import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.core.healthservice.TimeEntity;
import io.appform.ranger.core.healthservice.monitor.IsolatedHealthMonitor;
import io.appform.ranger.core.model.Serializer;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.core.serviceprovider.ServiceProvider;
import io.appform.ranger.discovery.bundle.Constants;
import io.appform.ranger.discovery.bundle.InfoResource;
import io.appform.ranger.discovery.bundle.ServiceDiscoveryConfiguration;
import io.appform.ranger.discovery.bundle.healthchecks.InitialDelayChecker;
import io.appform.ranger.discovery.bundle.healthchecks.InternalHealthChecker;
import io.appform.ranger.discovery.bundle.healthchecks.RotationCheck;
import io.appform.ranger.discovery.bundle.id.IdGenerator;
import io.appform.ranger.discovery.bundle.id.NodeIdManager;
import io.appform.ranger.discovery.bundle.id.constraints.IdValidationConstraint;
import io.appform.ranger.discovery.bundle.monitors.DropwizardHealthMonitor;
import io.appform.ranger.discovery.bundle.monitors.DropwizardServerStartupCheck;
import io.appform.ranger.discovery.bundle.resolvers.DefaultNodeInfoResolver;
import io.appform.ranger.discovery.bundle.resolvers.DefaultPortSchemeResolver;
import io.appform.ranger.discovery.bundle.resolvers.NodeInfoResolver;
import io.appform.ranger.discovery.bundle.resolvers.PortSchemeResolver;
import io.appform.ranger.discovery.bundle.rotationstatus.BIRTask;
import io.appform.ranger.discovery.bundle.rotationstatus.DropwizardServerStatus;
import io.appform.ranger.discovery.bundle.rotationstatus.OORTask;
import io.appform.ranger.discovery.bundle.rotationstatus.RotationStatus;
import io.appform.ranger.discovery.bundle.selectors.HierarchicalEnvironmentAwareShardSelector;
import io.appform.ranger.discovery.bundle.util.ConfigurationUtils;
import io.appform.ranger.zookeeper.ServiceProviderBuilders;
import io.appform.ranger.zookeeper.serde.ZkNodeDataSerializer;
import io.appform.ranger.zookeeper.serviceprovider.ZkServiceProviderBuilder;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceDiscoveryBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryBundle.class);
    private final List<Healthcheck> healthchecks = Lists.newArrayList();
    private final List<IdValidationConstraint> globalIdConstraints;
    private ServiceDiscoveryConfiguration serviceDiscoveryConfiguration;
    private ServiceProvider<ShardInfo, ZkNodeDataSerializer<ShardInfo>> serviceProvider;
    private CuratorFramework curator;
    private RangerClient<ShardInfo, MapBasedServiceRegistry<ShardInfo>> serviceDiscoveryClient;
    @VisibleForTesting
    private RotationStatus rotationStatus;
    @VisibleForTesting
    private DropwizardServerStatus serverStatus;

    protected ServiceDiscoveryBundle() {
        this.globalIdConstraints = Collections.emptyList();
    }

    protected ServiceDiscoveryBundle(List<IdValidationConstraint> globalIdConstraints) {
        this.globalIdConstraints = globalIdConstraints != null ? globalIdConstraints : Collections.emptyList();
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        PortSchemeResolver<T> portSchemeResolver = this.createPortSchemeResolver();
        Preconditions.checkNotNull(portSchemeResolver, (Object)"Port scheme resolver can't be null");
        String portScheme = (String)portSchemeResolver.resolve(configuration);
        this.serviceDiscoveryConfiguration = this.getRangerConfiguration(configuration);
        ObjectMapper objectMapper = environment.getObjectMapper();
        String namespace = this.serviceDiscoveryConfiguration.getNamespace();
        String serviceName = this.getServiceName(configuration);
        String hostname = this.getHost();
        int port = this.getPort(configuration);
        Predicate<ShardInfo> initialCriteria = this.getInitialCriteria(configuration);
        boolean useInitialCriteria = this.alwaysMergeWithInitialCriteria(configuration);
        ShardSelector<ShardInfo, MapBasedServiceRegistry<ShardInfo>> shardSelector = this.getShardSelector(configuration);
        this.rotationStatus = new RotationStatus(this.serviceDiscoveryConfiguration.isInitialRotationStatus());
        this.serverStatus = new DropwizardServerStatus(false);
        this.curator = CuratorFrameworkFactory.builder().connectString(this.serviceDiscoveryConfiguration.getZookeeper()).namespace(namespace).retryPolicy((RetryPolicy)new RetryForever(this.serviceDiscoveryConfiguration.getConnectionRetryIntervalMillis())).build();
        this.serviceProvider = this.buildServiceProvider(environment, objectMapper, namespace, serviceName, hostname, port, portScheme);
        this.serviceDiscoveryClient = this.buildDiscoveryClient(environment, namespace, serviceName, initialCriteria, useInitialCriteria, shardSelector);
        environment.lifecycle().manage((Managed)new ServiceDiscoveryManager(serviceName));
        environment.jersey().register((Object)new InfoResource(this.serviceDiscoveryClient));
        environment.admin().addTask((Task)new OORTask(this.rotationStatus));
        environment.admin().addTask((Task)new BIRTask(this.rotationStatus));
    }

    protected ShardSelector<ShardInfo, MapBasedServiceRegistry<ShardInfo>> getShardSelector(T configuration) {
        return new HierarchicalEnvironmentAwareShardSelector(this.getRangerConfiguration(configuration).getEnvironment());
    }

    protected abstract ServiceDiscoveryConfiguration getRangerConfiguration(T var1);

    protected abstract String getServiceName(T var1);

    protected NodeInfoResolver createNodeInfoResolver() {
        return new DefaultNodeInfoResolver();
    }

    protected PortSchemeResolver<T> createPortSchemeResolver() {
        return new DefaultPortSchemeResolver();
    }

    protected Predicate<ShardInfo> getInitialCriteria(T configuration) {
        return shardInfo -> true;
    }

    protected boolean alwaysMergeWithInitialCriteria(T configuration) {
        return false;
    }

    protected List<IsolatedHealthMonitor<HealthcheckStatus>> getHealthMonitors() {
        return Collections.emptyList();
    }

    protected int getPort(T configuration) {
        Preconditions.checkArgument((-1 != this.serviceDiscoveryConfiguration.getPublishedPort() && 0 != this.serviceDiscoveryConfiguration.getPublishedPort() ? 1 : 0) != 0, (Object)"Looks like publishedPost has not been set and getPort() has not been overridden. This is wrong. \nEither set publishedPort in config or override getPort() to return the port on which the service is running");
        return this.serviceDiscoveryConfiguration.getPublishedPort();
    }

    protected String getHost() throws UnknownHostException {
        String host = ConfigurationUtils.resolveNonEmptyPublishedHost(this.serviceDiscoveryConfiguration.getPublishedHost());
        String publishedHostAddress = InetAddress.getByName(host).getHostAddress();
        Set zkHostAddresses = ConfigurationUtils.resolveZookeeperHosts(this.serviceDiscoveryConfiguration.getZookeeper()).stream().map(zkHost -> {
            try {
                return InetAddress.getByName(zkHost).getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Couldn't resolve host address for zkHost : %s", zkHost), e);
            }
        }).collect(Collectors.toSet());
        Preconditions.checkArgument((!Constants.LOCAL_ADDRESSES.contains(publishedHostAddress) || Constants.LOCAL_ADDRESSES.containsAll(zkHostAddresses) ? 1 : 0) != 0, (Object)"Not allowed to publish localhost address to remote zookeeper");
        return host;
    }

    public void registerHealthcheck(Healthcheck healthcheck) {
        this.healthchecks.add(healthcheck);
    }

    public void registerHealthchecks(List<Healthcheck> healthchecks) {
        this.healthchecks.addAll(healthchecks);
    }

    private RangerClient<ShardInfo, MapBasedServiceRegistry<ShardInfo>> buildDiscoveryClient(Environment environment, String namespace, String serviceName, Predicate<ShardInfo> initialCriteria, boolean mergeWithInitialCriteria, ShardSelector<ShardInfo, MapBasedServiceRegistry<ShardInfo>> shardSelector) {
        return ((SimpleRangerZKClient.SimpleRangerZKClientBuilder)((SimpleRangerZKClient.SimpleRangerZKClientBuilder)SimpleRangerZKClient.builder().curatorFramework(this.curator).namespace(namespace).serviceName(serviceName).mapper(environment.getObjectMapper()).nodeRefreshIntervalMs(this.serviceDiscoveryConfiguration.getRefreshTimeMs()).disableWatchers(this.serviceDiscoveryConfiguration.isDisableWatchers()).deserializer(data -> {
            try {
                return (ServiceNode)environment.getObjectMapper().readValue(data, (TypeReference)new TypeReference<ServiceNode<ShardInfo>>(){});
            }
            catch (IOException e) {
                log.warn("Error parsing node data with value {}", (Object)new String(data));
                return null;
            }
        }).initialCriteria(initialCriteria)).alwaysUseInitialCriteria(mergeWithInitialCriteria)).shardSelector(shardSelector).build();
    }

    private ServiceProvider<ShardInfo, ZkNodeDataSerializer<ShardInfo>> buildServiceProvider(Environment environment, ObjectMapper objectMapper, String namespace, String serviceName, String hostname, int port, String portScheme) {
        NodeInfoResolver nodeInfoResolver = this.createNodeInfoResolver();
        ShardInfo nodeInfo = (ShardInfo)nodeInfoResolver.resolve(this.serviceDiscoveryConfiguration);
        long initialDelayForMonitor = this.serviceDiscoveryConfiguration.getInitialDelaySeconds() > 1L ? this.serviceDiscoveryConfiguration.getInitialDelaySeconds() - 1L : 0L;
        int dwMonitoringInterval = this.serviceDiscoveryConfiguration.getDropwizardCheckInterval() == 0 ? 15 : this.serviceDiscoveryConfiguration.getDropwizardCheckInterval();
        int dwMonitoringStaleness = Math.max(this.serviceDiscoveryConfiguration.getDropwizardCheckStaleness(), dwMonitoringInterval + 1);
        ZkServiceProviderBuilder serviceProviderBuilder = (ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)ServiceProviderBuilders.shardedServiceProviderBuilder().withCuratorFramework(this.curator).withNamespace(namespace).withServiceName(serviceName)).withSerializer((Serializer)((ZkNodeDataSerializer)data -> {
            try {
                return objectMapper.writeValueAsBytes((Object)data);
            }
            catch (Exception e) {
                log.warn("Could not parse node data", (Throwable)e);
                return null;
            }
        }))).withPortScheme(portScheme)).withNodeData((Object)nodeInfo)).withHostname(hostname)).withPort(port)).withHealthcheck((Healthcheck)new InternalHealthChecker(this.healthchecks))).withHealthcheck((Healthcheck)new RotationCheck(this.rotationStatus))).withHealthcheck((Healthcheck)new InitialDelayChecker(this.serviceDiscoveryConfiguration.getInitialDelaySeconds()))).withHealthcheck((Healthcheck)new DropwizardServerStartupCheck(environment, this.serverStatus))).withIsolatedHealthMonitor((IsolatedHealthMonitor)new DropwizardHealthMonitor(new TimeEntity(initialDelayForMonitor, (long)dwMonitoringInterval, TimeUnit.SECONDS), (long)dwMonitoringStaleness * 1000L, environment))).withHealthUpdateIntervalMs(this.serviceDiscoveryConfiguration.getRefreshTimeMs())).withStaleUpdateThresholdMs(10000);
        List<IsolatedHealthMonitor<HealthcheckStatus>> healthMonitors = this.getHealthMonitors();
        if (healthMonitors != null && !healthMonitors.isEmpty()) {
            healthMonitors.forEach(arg_0 -> ((ZkServiceProviderBuilder)serviceProviderBuilder).withIsolatedHealthMonitor(arg_0));
        }
        return serviceProviderBuilder.build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CuratorFramework getCurator() {
        return this.curator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RangerClient<ShardInfo, MapBasedServiceRegistry<ShardInfo>> getServiceDiscoveryClient() {
        return this.serviceDiscoveryClient;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RotationStatus getRotationStatus() {
        return this.rotationStatus;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DropwizardServerStatus getServerStatus() {
        return this.serverStatus;
    }

    private class ServiceDiscoveryManager
    implements Managed {
        private final String serviceName;

        public void start() {
            log.debug("Starting the discovery manager");
            ServiceDiscoveryBundle.this.curator.start();
            ServiceDiscoveryBundle.this.serviceProvider.start();
            ServiceDiscoveryBundle.this.serviceDiscoveryClient.start();
            NodeIdManager nodeIdManager = new NodeIdManager(ServiceDiscoveryBundle.this.curator, this.serviceName);
            IdGenerator.initialize(nodeIdManager.fixNodeId(), ServiceDiscoveryBundle.this.globalIdConstraints, Collections.emptyMap());
            log.debug("Discovery manager has been successfully started.");
        }

        public void stop() {
            ServiceDiscoveryBundle.this.serviceDiscoveryClient.stop();
            ServiceDiscoveryBundle.this.serviceProvider.stop();
            ServiceDiscoveryBundle.this.curator.close();
            IdGenerator.cleanUp();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ServiceDiscoveryManager(String serviceName) {
            this.serviceName = serviceName;
        }
    }
}

