/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.finder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.core.signals.ExternalTriggeredSignal;
import io.appform.ranger.core.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceFinder<T, R extends ServiceRegistry<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceFinder.class);
    private final R serviceRegistry;
    private final ShardSelector<T, R> shardSelector;
    private final ServiceNodeSelector<T> nodeSelector;
    private final ExternalTriggeredSignal<Void> startSignal = new ExternalTriggeredSignal<Void>(() -> null, Collections.emptyList());
    private final ExternalTriggeredSignal<Void> stopSignal = new ExternalTriggeredSignal<Void>(() -> null, Collections.emptyList());

    protected ServiceFinder(R serviceRegistry, ShardSelector<T, R> shardSelector, ServiceNodeSelector<T> nodeSelector) {
        this.serviceRegistry = serviceRegistry;
        this.shardSelector = shardSelector;
        this.nodeSelector = nodeSelector;
    }

    public Optional<ServiceNode<T>> get(Predicate<T> criteria) {
        return this.get(criteria, null);
    }

    public Optional<ServiceNode<T>> get(Predicate<T> criteria, ShardSelector<T, R> shardSelector) {
        return this.get(criteria, shardSelector, null);
    }

    public Optional<ServiceNode<T>> get(Predicate<T> criteria, ShardSelector<T, R> shardSelector, ServiceNodeSelector<T> nodeSelector) {
        List<ServiceNode<T>> nodes = ObjectUtils.requireNonNullElse(shardSelector, this.shardSelector).nodes(criteria, this.serviceRegistry);
        return nodes.isEmpty() ? Optional.empty() : Optional.ofNullable(ObjectUtils.requireNonNullElse(nodeSelector, this.nodeSelector).select(nodes));
    }

    public List<ServiceNode<T>> getAll(Predicate<T> criteria) {
        return this.getAll(criteria, this.shardSelector);
    }

    public List<ServiceNode<T>> getAll(Predicate<T> criteria, ShardSelector<T, R> shardSelector) {
        return ObjectUtils.requireNonNullElse(shardSelector, this.shardSelector).nodes(criteria, this.serviceRegistry);
    }

    public void start() {
        this.startSignal.trigger();
    }

    public void stop() {
        this.stopSignal.trigger();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public R getServiceRegistry() {
        return this.serviceRegistry;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExternalTriggeredSignal<Void> getStartSignal() {
        return this.startSignal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExternalTriggeredSignal<Void> getStopSignal() {
        return this.stopSignal;
    }
}

