/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.healthservice;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.healthcheck.Healthcheck;
import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.core.healthservice.HealthService;
import io.appform.ranger.core.healthservice.monitor.IsolatedHealthMonitor;
import io.appform.ranger.core.healthservice.monitor.Monitor;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceHealthAggregator
implements HealthService<HealthcheckStatus>,
Healthcheck {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceHealthAggregator.class);
    private final AtomicReference<HealthcheckStatus> healthcheckStatus = new AtomicReference();
    private List<ScheduledFuture<?>> scheduledFutureList;
    private final List<Monitor<HealthcheckStatus>> inlineHealthMonitorList;
    private final List<IsolatedHealthMonitor<HealthcheckStatus>> isolatedHealthMonitorList = Lists.newArrayList();
    private final AtomicBoolean running;

    public ServiceHealthAggregator() {
        this.inlineHealthMonitorList = Lists.newArrayList();
        this.running = new AtomicBoolean(false);
    }

    @Override
    public void addIsolatedMonitor(IsolatedHealthMonitor<HealthcheckStatus> monitor) {
        if (this.running.get()) {
            throw new IllegalStateException("Cannot add a monitor when Aggregator is running");
        }
        this.isolatedHealthMonitorList.add(monitor);
    }

    @Override
    public void addInlineMonitor(Monitor<HealthcheckStatus> monitor) {
        if (this.running.get()) {
            throw new IllegalStateException("Cannot add a monitor when Aggregator is running");
        }
        this.inlineHealthMonitorList.add(monitor);
    }

    @Override
    public void start() {
        if (this.running.get()) {
            log.info("Service aggregator is already running");
            return;
        }
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(this.isolatedHealthMonitorList.size());
        this.scheduledFutureList = Lists.newArrayListWithCapacity((int)this.isolatedHealthMonitorList.size());
        this.isolatedHealthMonitorList.stream().map(isolatedHealthMonitor -> scheduledExecutorService.scheduleWithFixedDelay((Runnable)isolatedHealthMonitor, isolatedHealthMonitor.getRunInterval().getInitialDelay(), isolatedHealthMonitor.getRunInterval().getTimeInterval(), isolatedHealthMonitor.getRunInterval().getTimeUnit())).forEach(scheduledFuture -> this.scheduledFutureList.add((ScheduledFuture<?>)scheduledFuture));
        this.running.set(true);
    }

    @Override
    public synchronized void stop() {
        if (this.running.get()) {
            log.error("Service aggregator is currently not running, cannot stop..");
            return;
        }
        this.scheduledFutureList.forEach(scheduledFuture -> scheduledFuture.cancel(true));
        this.running.set(false);
    }

    @Override
    public HealthcheckStatus getServiceHealth() {
        this.healthcheckStatus.set(HealthcheckStatus.healthy);
        Date currentTime = new Date();
        boolean hasUnhealthyMonitor = this.isolatedHealthMonitorList.stream().filter(isolatedHealthMonitor -> !isolatedHealthMonitor.isDisabled()).anyMatch(isolatedHealthMonitor -> this.isIsolatedMonitorUnHealthy((IsolatedHealthMonitor<HealthcheckStatus>)isolatedHealthMonitor, currentTime));
        if (hasUnhealthyMonitor) {
            this.healthcheckStatus.set(HealthcheckStatus.unhealthy);
        }
        this.processMonitors();
        return this.healthcheckStatus.get();
    }

    @Override
    public HealthcheckStatus check() {
        return this.getServiceHealth();
    }

    private boolean isIsolatedMonitorUnHealthy(IsolatedHealthMonitor<HealthcheckStatus> isolatedHealthMonitor, Date currentTime) {
        if (HealthcheckStatus.unhealthy == isolatedHealthMonitor.getHealthStatus()) {
            return true;
        }
        boolean hasValidUpdateTime = isolatedHealthMonitor.hasValidUpdatedTime(currentTime);
        if (!hasValidUpdateTime) {
            log.error("Monitor: {} is stuck and its status is stale. Marking service as unhealthy", (Object)isolatedHealthMonitor.getName());
            return true;
        }
        return false;
    }

    private void processMonitors() {
        this.inlineHealthMonitorList.stream().filter(healthMonitor -> !healthMonitor.isDisabled()).map(Monitor::monitor).filter(monitorStatus -> HealthcheckStatus.unhealthy == monitorStatus).forEach(monitorStatus -> this.healthcheckStatus.set(HealthcheckStatus.unhealthy));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AtomicBoolean getRunning() {
        return this.running;
    }
}

