/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.finderhub;

import com.github.rholder.retry.RetryerBuilder;
import com.google.common.base.Stopwatch;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.finder.ServiceFinder;
import io.appform.ranger.core.finderhub.ServiceDataSource;
import io.appform.ranger.core.finderhub.ServiceFinderFactory;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.core.signals.ExternalTriggeredSignal;
import io.appform.ranger.core.signals.ScheduledSignal;
import io.appform.ranger.core.signals.Signal;
import io.appform.ranger.core.util.Exceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFinderHub<T, R extends ServiceRegistry<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceFinderHub.class);
    private final AtomicReference<Map<Service, ServiceFinder<T, R>>> finders = new AtomicReference(new HashMap());
    private final Lock updateLock = new ReentrantLock();
    private final Condition updateCond = this.updateLock.newCondition();
    private boolean updateAvailable = false;
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private final ExternalTriggeredSignal<Void> startSignal = new ExternalTriggeredSignal<Void>(() -> null, Collections.emptyList());
    private final ExternalTriggeredSignal<Void> stopSignal = new ExternalTriggeredSignal<Void>(() -> null, Collections.emptyList());
    private final List<Signal<Void>> refreshSignals = new ArrayList<Signal<Void>>();
    private final ServiceDataSource serviceDataSource;
    private final ServiceFinderFactory<T, R> finderFactory;
    private final AtomicBoolean alreadyUpdating = new AtomicBoolean(false);
    private Future<?> monitorFuture = null;

    public ServiceFinderHub(ServiceDataSource serviceDataSource, ServiceFinderFactory<T, R> finderFactory) {
        this.serviceDataSource = serviceDataSource;
        this.finderFactory = finderFactory;
        this.refreshSignals.add(new ScheduledSignal<Void>("service-hub-updater", () -> null, Collections.emptyList(), 10000L));
    }

    public Optional<ServiceFinder<T, R>> finder(Service service) {
        return Optional.ofNullable(this.finders.get().get(service));
    }

    public void start() {
        log.info("Waiting for the service finder hub to start");
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.monitorFuture = this.executorService.submit(this::monitor);
        this.refreshSignals.forEach(signal -> signal.registerConsumer(x -> this.updateAvailable()));
        this.startSignal.trigger();
        this.updateAvailable();
        this.waitTillHubIsReady();
        log.info("Service finder hub started in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public void stop() {
        this.stopSignal.trigger();
        if (null != this.monitorFuture) {
            try {
                this.monitorFuture.cancel(true);
            }
            catch (Exception e) {
                log.warn("Error stopping service finder hub monitor: {}", (Object)e.getMessage());
            }
        }
        log.info("Service finder hub stopped");
    }

    public void registerUpdateSignal(Signal<Void> refreshSignal) {
        this.refreshSignals.add(refreshSignal);
    }

    public void updateAvailable() {
        try {
            this.updateLock.lock();
            this.updateAvailable = true;
            this.updateCond.signalAll();
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private void monitor() {
        while (true) {
            try {
                this.updateLock.lock();
                while (!this.updateAvailable) {
                    this.updateCond.await();
                }
                this.updateRegistry();
                continue;
            }
            catch (InterruptedException e) {
                log.info("Updater thread interrupted");
                Thread.currentThread().interrupt();
            }
            finally {
                this.updateAvailable = false;
                this.updateLock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRegistry() {
        if (this.alreadyUpdating.get()) {
            log.warn("Service hub is already updating");
            return;
        }
        this.alreadyUpdating.set(true);
        HashMap<Object, ServiceFinder> updatedFinders = new HashMap<Object, ServiceFinder>();
        try {
            Collection<Service> services = this.serviceDataSource.services();
            Map knownServiceFinders = this.finders.get();
            Map newFinders = services.stream().filter(service -> !knownServiceFinders.containsKey(service)).collect(Collectors.toMap(Function.identity(), this.finderFactory::buildFinder));
            Map<Service, ServiceFinder> matchingServices = knownServiceFinders.entrySet().stream().filter(entry -> services.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (newFinders.isEmpty() && matchingServices.size() == knownServiceFinders.size()) {
                log.debug("No update to known list of services. Skipping update on the registry.");
                return;
            }
            updatedFinders.putAll(newFinders);
            updatedFinders.putAll(matchingServices);
        }
        catch (Exception e) {
            log.error("Error updating service list. Will maintain older list", (Throwable)e);
        }
        finally {
            this.alreadyUpdating.set(false);
        }
        this.finders.set(updatedFinders);
    }

    private void waitTillHubIsReady() {
        this.serviceDataSource.services().forEach(service -> {
            try {
                RetryerBuilder.newBuilder().retryIfResult(r -> r == false).build().call(() -> Optional.ofNullable(this.getFinders().get().get(service)).map(ServiceFinder::getServiceRegistry).map(ServiceRegistry::isRefreshed).orElse(false));
            }
            catch (Exception e) {
                Exceptions.illegalState("Could not perform initial state for service: " + service.getServiceName(), e);
            }
        });
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AtomicReference<Map<Service, ServiceFinder<T, R>>> getFinders() {
        return this.finders;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExternalTriggeredSignal<Void> getStartSignal() {
        return this.startSignal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExternalTriggeredSignal<Void> getStopSignal() {
        return this.stopSignal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ServiceDataSource getServiceDataSource() {
        return this.serviceDataSource;
    }
}

