/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.finder.serviceregistry;

import com.github.rholder.retry.RetryerBuilder;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.Deserializer;
import io.appform.ranger.core.model.NodeDataSource;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.core.signals.Signal;
import io.appform.ranger.core.util.Exceptions;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryUpdater<T, D extends Deserializer<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceRegistryUpdater.class);
    private final ServiceRegistry<T> serviceRegistry;
    private final NodeDataSource<T, D> nodeDataSource;
    private final D deserializer;
    private final Lock checkLock = new ReentrantLock();
    private final Condition checkCondition = this.checkLock.newCondition();
    private boolean checkForUpdate = false;
    private Future<Void> queryThreadFuture;
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);

    public ServiceRegistryUpdater(ServiceRegistry<T> serviceRegistry, NodeDataSource<T, D> nodeDataSource, List<Signal<T>> signalGenerators, D deserializer) {
        this.serviceRegistry = serviceRegistry;
        this.nodeDataSource = nodeDataSource;
        this.deserializer = deserializer;
        signalGenerators.forEach(signalGenerator -> signalGenerator.registerConsumer(this::checkForUpdate));
    }

    public void start() {
        String serviceName = this.serviceRegistry.getService().getServiceName();
        this.queryThreadFuture = this.executorService.submit(this::queryExecutor);
        log.info("Started updater for [{}]. Triggering initial update.", (Object)serviceName);
        this.checkForUpdate(null);
        log.info("Waiting for initial update to complete for: {}", (Object)serviceName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            RetryerBuilder.newBuilder().retryIfResult(r -> null == r || r == false).build().call(this.serviceRegistry::isRefreshed);
        }
        catch (Exception e) {
            Exceptions.illegalState("Could not perform initial state for service: " + serviceName, e);
        }
        log.info("Initial node list updated for service: {} in {}ms", (Object)serviceName, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public void stop() {
        if (null != this.queryThreadFuture) {
            this.executorService.shutdownNow();
        }
    }

    public void checkForUpdate(T signalData) {
        Preconditions.checkArgument((null == signalData ? 1 : 0) != 0);
        try {
            this.checkLock.lock();
            this.checkForUpdate = true;
            this.checkCondition.signalAll();
        }
        finally {
            this.checkLock.unlock();
        }
    }

    private Void queryExecutor() {
        while (true) {
            try {
                this.checkLock.lock();
                while (!this.checkForUpdate) {
                    this.checkCondition.await();
                }
                this.updateRegistry();
                continue;
            }
            catch (InterruptedException e) {
                log.info("Updater thread interrupted");
                Thread.currentThread().interrupt();
                Void void_ = null;
                return void_;
            }
            catch (Exception e) {
                log.error("Registry update failed for service: " + this.serviceRegistry.getService().name(), (Throwable)e);
                continue;
            }
            finally {
                this.checkForUpdate = false;
                this.checkLock.unlock();
                continue;
            }
            break;
        }
    }

    private void updateRegistry() throws InterruptedException {
        log.debug("Checking for updates on data source for service: {}", (Object)this.serviceRegistry.getService().getServiceName());
        if (!this.nodeDataSource.isActive()) {
            log.warn("Node data source seems to be down. Keeping old list for {}", (Object)this.serviceRegistry.getService().getServiceName());
            return;
        }
        List<ServiceNode<T>> nodeList = this.nodeDataSource.refresh(this.deserializer);
        if (null != nodeList) {
            log.debug("Updating nodelist of size: {} for [{}]", (Object)nodeList.size(), (Object)this.serviceRegistry.getService().getServiceName());
            this.serviceRegistry.updateNodes(nodeList);
        } else {
            log.warn("Empty list returned from node data source. We are in a weird state. Keeping old list for {}", (Object)this.serviceRegistry.getService().getServiceName());
        }
    }
}

