/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.healthservice.monitor;

import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.core.healthservice.monitor.Monitor;
import java.io.File;

public class Monitors {
    private Monitors() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static Monitor<HealthcheckStatus> fileExistenceCheckMonitor(final String filePath) {
        return new Monitor<HealthcheckStatus>(){

            @Override
            public HealthcheckStatus monitor() {
                File file = new File(filePath);
                return file.exists() ? HealthcheckStatus.healthy : HealthcheckStatus.unhealthy;
            }

            @Override
            public boolean isDisabled() {
                return false;
            }
        };
    }

    public static Monitor<HealthcheckStatus> defaultHealthyMonitor() {
        return new Monitor<HealthcheckStatus>(){

            @Override
            public HealthcheckStatus monitor() {
                return HealthcheckStatus.healthy;
            }

            @Override
            public boolean isDisabled() {
                return false;
            }
        };
    }
}

