/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.finder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.finder.ServiceFinder;
import io.appform.ranger.core.finder.nodeselector.RandomServiceNodeSelector;
import io.appform.ranger.core.finder.serviceregistry.ServiceRegistryUpdater;
import io.appform.ranger.core.finder.serviceregistry.signal.ScheduledRegistryUpdateSignal;
import io.appform.ranger.core.model.Deserializer;
import io.appform.ranger.core.model.NodeDataSource;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.core.signals.Signal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServiceFinderBuilder<T, R extends ServiceRegistry<T>, F extends ServiceFinder<T, R>, B extends BaseServiceFinderBuilder<T, R, F, B, D>, D extends Deserializer<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseServiceFinderBuilder.class);
    protected String namespace;
    protected String serviceName;
    protected int nodeRefreshIntervalMs;
    protected boolean disablePushUpdaters;
    protected D deserializer;
    protected ShardSelector<T, R> shardSelector;
    protected ServiceNodeSelector<T> nodeSelector = new RandomServiceNodeSelector();
    protected final List<Signal<T>> additionalRefreshSignals = new ArrayList<Signal<T>>();
    protected final List<Consumer<Void>> startSignalHandlers = Lists.newArrayList();
    protected final List<Consumer<Void>> stopSignalHandlers = Lists.newArrayList();

    public B withNamespace(String namespace) {
        this.namespace = namespace;
        return (B)this;
    }

    public B withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (B)this;
    }

    public B withDeserializer(D deserializer) {
        this.deserializer = deserializer;
        return (B)this;
    }

    public B withShardSelector(ShardSelector<T, R> shardSelector) {
        this.shardSelector = shardSelector;
        return (B)this;
    }

    public B withNodeSelector(ServiceNodeSelector<T> nodeSelector) {
        this.nodeSelector = null != nodeSelector ? nodeSelector : this.nodeSelector;
        return (B)this;
    }

    public B withNodeRefreshIntervalMs(int nodeRefreshIntervalMs) {
        this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
        return (B)this;
    }

    public B withDisableWatchers() {
        this.disablePushUpdaters = true;
        return (B)this;
    }

    public B withDisableWatchers(boolean disablePushUpdaters) {
        this.disablePushUpdaters = disablePushUpdaters;
        return (B)this;
    }

    public B withAdditionalSignalGenerator(Signal<T> signalGenerator) {
        this.additionalRefreshSignals.add(signalGenerator);
        return (B)this;
    }

    public B withAdditionalSignalGenerators(Signal<T> ... signalGenerators) {
        this.additionalRefreshSignals.addAll(Arrays.asList(signalGenerators));
        return (B)this;
    }

    public B withAdditionalSignalGenerators(List<Signal<T>> signalGenerators) {
        this.additionalRefreshSignals.addAll(signalGenerators);
        return (B)this;
    }

    public B withStartSignalHandler(Consumer<Void> startSignalHandler) {
        this.startSignalHandlers.add(startSignalHandler);
        return (B)this;
    }

    public B withStartSignalHandlers(List<Consumer<Void>> startSignalHandlers) {
        this.startSignalHandlers.addAll(startSignalHandlers);
        return (B)this;
    }

    public B withStopSignalHandler(Consumer<Void> stopSignalHandler) {
        this.stopSignalHandlers.add(stopSignalHandler);
        return (B)this;
    }

    public B withStopSignalHandlers(List<Consumer<Void>> stopSignalHandlers) {
        this.stopSignalHandlers.addAll(stopSignalHandlers);
        return (B)this;
    }

    public abstract F build();

    protected F buildFinder() {
        Preconditions.checkNotNull((Object)this.namespace);
        Preconditions.checkNotNull((Object)this.serviceName);
        Preconditions.checkNotNull(this.deserializer);
        if (this.nodeRefreshIntervalMs < 1000) {
            log.warn("Node refresh interval for {} is too low: {} ms. Has been upgraded to 1000ms ", (Object)this.serviceName, (Object)this.nodeRefreshIntervalMs);
            this.nodeRefreshIntervalMs = 1000;
        }
        Service service = Service.builder().namespace(this.namespace).serviceName(this.serviceName).build();
        F finder = this.buildFinder(service, this.shardSelector, this.nodeSelector);
        Object registry = ((ServiceFinder)finder).getServiceRegistry();
        ArrayList signalGenerators = new ArrayList();
        NodeDataSource nodeDataSource = this.dataSource(service);
        signalGenerators.add(new ScheduledRegistryUpdateSignal(service, this.nodeRefreshIntervalMs));
        this.additionalRefreshSignals.addAll(this.implementationSpecificRefreshSignals(service, nodeDataSource));
        if (!this.additionalRefreshSignals.isEmpty()) {
            signalGenerators.addAll(this.additionalRefreshSignals);
            log.debug("Added additional signal handlers");
        }
        ServiceRegistryUpdater updater = new ServiceRegistryUpdater(registry, nodeDataSource, signalGenerators, this.deserializer);
        ((ServiceFinder)finder).getStartSignal().registerConsumers(this.startSignalHandlers).registerConsumer(x -> nodeDataSource.start()).registerConsumer(x -> updater.start()).registerConsumer(x -> signalGenerators.forEach(Signal::start));
        ((ServiceFinder)finder).getStopSignal().registerConsumer(x -> signalGenerators.forEach(Signal::stop)).registerConsumer(x -> updater.stop()).registerConsumer(x -> nodeDataSource.stop()).registerConsumers(this.stopSignalHandlers);
        return finder;
    }

    protected List<Signal<T>> implementationSpecificRefreshSignals(Service service, NodeDataSource<T, D> nodeDataSource) {
        return Collections.emptyList();
    }

    protected abstract NodeDataSource<T, D> dataSource(Service var1);

    protected abstract F buildFinder(Service var1, ShardSelector<T, R> var2, ServiceNodeSelector<T> var3);
}

