/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.signals;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class Signal<T> {
    private final Supplier<T> signalDataGenerator;
    private final List<Consumer<T>> consumers = new ArrayList<Consumer<T>>();

    protected Signal(Supplier<T> signalDataGenerator, List<Consumer<T>> consumers) {
        this.signalDataGenerator = signalDataGenerator;
        if (null != consumers) {
            this.consumers.addAll(consumers);
        }
    }

    protected void onSignalReceived() {
        Object signalData = this.signalDataGenerator.get();
        this.consumers.forEach(consumer -> consumer.accept(signalData));
    }

    public Signal<T> registerConsumer(Consumer<T> consumer) {
        this.consumers.add(consumer);
        return this;
    }

    public Signal<T> registerConsumers(List<Consumer<T>> consumers) {
        this.consumers.addAll(consumers);
        return this;
    }

    public abstract void start();

    public abstract void stop();
}

