/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.serviceprovider;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.healthcheck.HealthcheckResult;
import io.appform.ranger.core.model.NodeDataSink;
import io.appform.ranger.core.model.Serializer;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.signals.ExternalTriggeredSignal;
import io.appform.ranger.core.signals.Signal;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProvider<T, S extends Serializer<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceProvider.class);
    private final Service service;
    private final ServiceNode<T> serviceNode;
    private final S serializer;
    private final NodeDataSink<T, S> dataSink;
    private final ExternalTriggeredSignal<Void> startSignal = new ExternalTriggeredSignal<Void>(() -> null, Collections.emptyList());
    private final ExternalTriggeredSignal<Void> stopSignal = new ExternalTriggeredSignal<Void>(() -> null, Collections.emptyList());

    public ServiceProvider(Service service, ServiceNode<T> serviceNode, S serializer, NodeDataSink<T, S> dataSink, List<Signal<HealthcheckResult>> signalGenerators) {
        this.service = service;
        this.serviceNode = serviceNode;
        this.serializer = serializer;
        this.dataSink = dataSink;
        signalGenerators.forEach(signalGenerator -> signalGenerator.registerConsumer(this::handleHealthUpdate));
    }

    public void start() {
        this.startSignal.trigger();
        this.dataSink.updateState(this.serializer, this.serviceNode);
        log.debug("Set initial node data on zookeeper for {}", (Object)this.service.getServiceName());
    }

    public void stop() {
        this.stopSignal.trigger();
    }

    private void handleHealthUpdate(HealthcheckResult result) {
        if (null == result) {
            log.debug("No update to health state of node. Skipping data source update.");
            return;
        }
        this.serviceNode.setHealthcheckStatus(result.getStatus());
        this.serviceNode.setLastUpdatedTimeStamp(result.getUpdatedTime());
        this.dataSink.updateState(this.serializer, this.serviceNode);
        log.debug("Updated node with health check result: {}", (Object)result);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExternalTriggeredSignal<Void> getStartSignal() {
        return this.startSignal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExternalTriggeredSignal<Void> getStopSignal() {
        return this.stopSignal;
    }
}

