/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.serviceprovider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.healthcheck.HealthChecker;
import io.appform.ranger.core.healthcheck.Healthcheck;
import io.appform.ranger.core.healthcheck.HealthcheckResult;
import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.core.healthservice.HealthService;
import io.appform.ranger.core.healthservice.ServiceHealthAggregator;
import io.appform.ranger.core.healthservice.monitor.IsolatedHealthMonitor;
import io.appform.ranger.core.model.NodeDataSink;
import io.appform.ranger.core.model.Serializer;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.serviceprovider.ServiceProvider;
import io.appform.ranger.core.signals.ExternalTriggeredSignal;
import io.appform.ranger.core.signals.ScheduledSignal;
import io.appform.ranger.core.signals.Signal;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServiceProviderBuilder<T, B extends BaseServiceProviderBuilder<T, B, S>, S extends Serializer<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseServiceProviderBuilder.class);
    protected String namespace;
    protected String serviceName;
    protected S serializer;
    protected String hostname;
    protected int port;
    protected String portScheme;
    protected T nodeData;
    protected int healthUpdateIntervalMs;
    protected int staleUpdateThresholdMs;
    protected NodeDataSink<T, S> nodeDataSource = null;
    protected final List<Healthcheck> healthchecks = Lists.newArrayList();
    protected final List<Consumer<Void>> startSignalHandlers = Lists.newArrayList();
    protected final List<Consumer<Void>> stopSignalHandlers = Lists.newArrayList();
    protected final List<Signal<HealthcheckResult>> additionalRefreshSignals = Lists.newArrayList();
    private final List<IsolatedHealthMonitor<HealthcheckStatus>> isolatedMonitors = Lists.newArrayList();

    public BaseServiceProviderBuilder<T, B, S> withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public B withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (B)this;
    }

    public B withSerializer(S serializer) {
        this.serializer = serializer;
        return (B)this;
    }

    public B withHostname(String hostname) {
        this.hostname = hostname;
        return (B)this;
    }

    public B withPort(int port) {
        this.port = port;
        return (B)this;
    }

    public B withPortScheme(String portScheme) {
        this.portScheme = portScheme;
        return (B)this;
    }

    public B withNodeData(T nodeData) {
        this.nodeData = nodeData;
        return (B)this;
    }

    public B withHealthcheck(Healthcheck healthcheck) {
        this.healthchecks.add(healthcheck);
        return (B)this;
    }

    public B withHealthUpdateIntervalMs(int healthUpdateIntervalMs) {
        this.healthUpdateIntervalMs = healthUpdateIntervalMs;
        return (B)this;
    }

    public B withStaleUpdateThresholdMs(int staleUpdateThresholdMs) {
        this.staleUpdateThresholdMs = staleUpdateThresholdMs;
        return (B)this;
    }

    public B withIsolatedHealthMonitor(IsolatedHealthMonitor<HealthcheckStatus> monitor) {
        this.isolatedMonitors.add(monitor);
        return (B)this;
    }

    public B withNodeDataSource(NodeDataSink<T, S> nodeDataSource) {
        this.nodeDataSource = nodeDataSource;
        return (B)this;
    }

    public B withStartSignalHandler(Consumer<Void> startSignalHandler) {
        this.startSignalHandlers.add(startSignalHandler);
        return (B)this;
    }

    public B withStartSignalHandlers(List<Consumer<Void>> startSignalHandlers) {
        this.startSignalHandlers.addAll(startSignalHandlers);
        return (B)this;
    }

    public B withStopSignalHandler(Consumer<Void> stopSignalHandler) {
        this.stopSignalHandlers.add(stopSignalHandler);
        return (B)this;
    }

    public B withStopSignalHandlers(List<Consumer<Void>> stopSignalHandlers) {
        this.stopSignalHandlers.addAll(stopSignalHandlers);
        return (B)this;
    }

    public B withAdditionalRefreshSignal(Signal<HealthcheckResult> additionalRefreshSignal) {
        this.additionalRefreshSignals.add(additionalRefreshSignal);
        return (B)this;
    }

    public B withAdditionalRefreshSignals(List<Signal<HealthcheckResult>> additionalRefreshSignals) {
        this.additionalRefreshSignals.addAll(additionalRefreshSignals);
        return (B)this;
    }

    protected final ServiceProvider<T, S> buildProvider() {
        Preconditions.checkNotNull((Object)this.namespace);
        Preconditions.checkNotNull((Object)this.serviceName);
        Preconditions.checkNotNull(this.serializer);
        Preconditions.checkNotNull((Object)this.hostname);
        Preconditions.checkArgument((this.port > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.healthchecks.isEmpty() || !this.isolatedMonitors.isEmpty() ? 1 : 0) != 0);
        if (this.healthUpdateIntervalMs < 1000 || this.healthUpdateIntervalMs > 20000) {
            log.warn("Health update interval for {} should be between 1000ms and 20000ms. Current value: {} ms. Being set to 1000ms", (Object)this.serviceName, (Object)this.healthUpdateIntervalMs);
            this.healthUpdateIntervalMs = 1000;
        }
        if (this.staleUpdateThresholdMs < 5000 || this.staleUpdateThresholdMs > 20000) {
            log.warn("Stale update threshold for {} should be between 5000ms and 20000ms. Current value: {} ms. Being set to 5000ms", (Object)this.serviceName, (Object)this.staleUpdateThresholdMs);
            this.staleUpdateThresholdMs = 5000;
        }
        ServiceHealthAggregator serviceHealthAggregator = new ServiceHealthAggregator();
        this.isolatedMonitors.forEach(serviceHealthAggregator::addIsolatedMonitor);
        this.healthchecks.add(serviceHealthAggregator);
        Service service = Service.builder().namespace(this.namespace).serviceName(this.serviceName).build();
        NodeDataSink usableNodeDataSource = this.dataSink(service);
        ScheduledSignal<HealthcheckResult> healthcheckUpdateSignalGenerator = new ScheduledSignal<HealthcheckResult>(service, new HealthChecker(this.healthchecks, this.staleUpdateThresholdMs), Collections.emptyList(), (long)this.healthUpdateIntervalMs);
        List<ServiceHealthAggregator> healthServices = Collections.singletonList(serviceHealthAggregator);
        ImmutableList signalGenerators = ImmutableList.builder().add(healthcheckUpdateSignalGenerator).addAll(this.additionalRefreshSignals).build();
        ServiceNode serviceNode = ServiceNode.builder().host(this.hostname).port(this.port).portScheme(this.portScheme).nodeData(this.nodeData).build();
        ServiceProvider serviceProvider = new ServiceProvider(service, serviceNode, this.serializer, usableNodeDataSource, (List<Signal<HealthcheckResult>>)signalGenerators);
        ExternalTriggeredSignal<Void> startSignal = serviceProvider.getStartSignal();
        startSignal.registerConsumers(this.startSignalHandlers).registerConsumer(x -> usableNodeDataSource.start()).registerConsumer(x -> healthServices.forEach(HealthService::start)).registerConsumer(x -> signalGenerators.forEach(Signal::start));
        ExternalTriggeredSignal<Void> stopSignal = serviceProvider.getStopSignal();
        stopSignal.registerConsumer(x -> healthServices.forEach(HealthService::stop)).registerConsumer(x -> signalGenerators.forEach(Signal::stop)).registerConsumer(x -> usableNodeDataSource.stop()).registerConsumers(this.stopSignalHandlers);
        return serviceProvider;
    }

    public abstract ServiceProvider<T, S> build();

    protected abstract NodeDataSink<T, S> dataSink(Service var1);

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected BaseServiceProviderBuilder() {
    }
}

