/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.healthservice.monitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.healthservice.TimeEntity;
import io.appform.ranger.core.healthservice.monitor.Monitor;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

public abstract class IsolatedHealthMonitor<T>
implements Runnable,
Monitor<T> {
    protected String name;
    private final AtomicReference<T> healthStatus;
    private Date lastStatusUpdateTime;
    private final TimeEntity runInterval;
    private final AtomicBoolean disabled = new AtomicBoolean(false);
    private final long stalenessAllowedInMillis;

    protected IsolatedHealthMonitor(String name, TimeEntity runInterval) {
        this(name, runInterval, 60000L);
    }

    protected IsolatedHealthMonitor(String name, TimeEntity runInterval, long stalenessAllowedInMillis) {
        this.name = name;
        this.stalenessAllowedInMillis = stalenessAllowedInMillis;
        this.healthStatus = new AtomicReference();
        this.runInterval = runInterval;
        this.disabled.set(false);
    }

    @Override
    public void run() {
        this.healthStatus.set(this.monitor());
        this.lastStatusUpdateTime = new Date();
    }

    public void disable() {
        this.disabled.set(true);
    }

    public void enable() {
        this.disabled.set(false);
    }

    public T getHealthStatus() {
        return this.healthStatus.get();
    }

    @Override
    public boolean isDisabled() {
        return this.disabled.get();
    }

    public boolean hasValidUpdatedTime(Date currentTime) {
        return null != this.lastStatusUpdateTime && currentTime.getTime() - this.lastStatusUpdateTime.getTime() <= this.stalenessAllowedInMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TimeEntity getRunInterval() {
        return this.runInterval;
    }
}

