/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.serviceprovider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.appform.ranger.core.healthcheck.Healthchecks;
import io.appform.ranger.core.model.NodeDataSink;
import io.appform.ranger.core.model.Serializer;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.serviceprovider.BaseServiceProviderBuilder;
import io.appform.ranger.core.serviceprovider.ServiceProvider;
import io.appform.ranger.core.units.TestNodeData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ServiceProviderTest {
    static TestNodeData testNodeData = null;

    ServiceProviderTest() {
    }

    @Test
    void testInvalidServiceProvider() {
        Assertions.assertThrowsExactly(NullPointerException.class, () -> ((TestServiceProviderBuilder)((TestServiceProviderBuilder)((TestServiceProviderBuilder)new TestServiceProviderBuilder().withServiceName("test-service")).withNamespace("test").withHostname("localhost-1")).withPort(9000)).build());
    }

    @Test
    void testInvalidServiceProviderNoHealthCheck() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> ((TestServiceProviderBuilder)((TestServiceProviderBuilder)((TestServiceProviderBuilder)((TestServiceProviderBuilder)new TestServiceProviderBuilder().withServiceName("test-service")).withNamespace("test").withHostname("localhost-1")).withPort(9000)).withSerializer(new TestSerializerImpl())).build());
    }

    @Test
    void testBuildServiceProvider() {
        ServiceProvider testProvider = ((TestServiceProviderBuilder)((TestServiceProviderBuilder)((TestServiceProviderBuilder)((TestServiceProviderBuilder)((TestServiceProviderBuilder)((TestServiceProviderBuilder)((TestServiceProviderBuilder)new TestServiceProviderBuilder().withServiceName("test-service")).withNamespace("test").withHostname("localhost-1")).withPort(9000)).withSerializer(new TestSerializerImpl())).withNodeData(TestNodeData.builder().shardId(1).build())).withHealthcheck(Healthchecks.defaultHealthyCheck())).withHealthUpdateIntervalMs(1000)).build();
        testProvider.start();
        Assertions.assertNotNull((Object)testNodeData);
        Assertions.assertEquals((int)1, (int)testNodeData.getShardId());
    }

    public static class TestServiceProviderBuilder<T extends TestNodeData>
    extends BaseServiceProviderBuilder<T, TestServiceProviderBuilder<T>, TestSerializer<T>> {
        public ServiceProvider<T, TestSerializer<T>> build() {
            return super.buildProvider();
        }

        protected NodeDataSink<T, TestSerializer<T>> dataSink(Service service) {
            return new TestNodeDataSink();
        }
    }

    static class TestSerializerImpl
    implements TestSerializer<TestNodeData> {
        private final ObjectMapper objectMapper = new ObjectMapper();

        @Override
        public byte[] serialize(ServiceNode<TestNodeData> node) {
            try {
                return this.objectMapper.writeValueAsBytes(node);
            }
            catch (JsonProcessingException jpe) {
                return null;
            }
        }
    }

    static class TestNodeDataSink<T extends TestNodeData, S extends TestSerializer<T>>
    implements NodeDataSink<T, S> {
        public void updateState(S serializer, ServiceNode<T> serviceNode) {
            testNodeData = (TestNodeData)serviceNode.getNodeData();
        }

        public void start() {
        }

        public void ensureConnected() {
        }

        public void stop() {
        }

        public boolean isActive() {
            return true;
        }
    }

    static interface TestSerializer<T>
    extends Serializer<T> {
        public byte[] serialize(ServiceNode<TestNodeData> var1);
    }
}

