/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.finderhub;

import com.google.common.collect.Lists;
import io.appform.ranger.core.finder.BaseServiceFinderBuilder;
import io.appform.ranger.core.finder.ServiceFinder;
import io.appform.ranger.core.finder.SimpleShardedServiceFinder;
import io.appform.ranger.core.finder.serviceregistry.MapBasedServiceRegistry;
import io.appform.ranger.core.finder.shardselector.MatchingShardSelector;
import io.appform.ranger.core.finderhub.DynamicDataSource;
import io.appform.ranger.core.finderhub.ServiceDataSource;
import io.appform.ranger.core.finderhub.ServiceFinderHub;
import io.appform.ranger.core.finderhub.StaticDataSource;
import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.core.model.Deserializer;
import io.appform.ranger.core.model.NodeDataSource;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.core.units.TestNodeData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ServiceFinderHubTest {
    private final ServiceFinderHub<TestNodeData, MapBasedServiceRegistry<TestNodeData>> serviceFinderHub = new ServiceFinderHub((ServiceDataSource)new DynamicDataSource((Collection)Lists.newArrayList((Object[])new Service[]{new Service("NS", "PRE_REGISTERED_SERVICE")})), service -> ((TestServiceFinderBuilder)((TestServiceFinderBuilder)((TestServiceFinderBuilder)new TestServiceFinderBuilder().withNamespace(service.getNamespace())).withServiceName(service.getServiceName())).withDeserializer((Deserializer)new Deserializer<TestNodeData>(){})).build());

    ServiceFinderHubTest() {
    }

    @Test
    void testDynamicServiceAddition() {
        this.serviceFinderHub.start();
        ServiceFinder preRegisteredServiceFinder = (ServiceFinder)this.serviceFinderHub.finder(new Service("NS", "PRE_REGISTERED_SERVICE")).orElseThrow(() -> new IllegalStateException("Finder should be present"));
        Optional node = preRegisteredServiceFinder.get(null, (criteria, serviceRegistry) -> serviceRegistry.nodeList());
        Assertions.assertTrue((boolean)node.isPresent());
        Assertions.assertEquals((Object)"HOST", (Object)((ServiceNode)node.get()).getHost());
        Assertions.assertEquals((int)0, (int)((ServiceNode)node.get()).getPort());
        this.serviceFinderHub.buildFinder(new Service("NS", "SERVICE")).join();
        ServiceFinder dynamicServiceFinder = (ServiceFinder)this.serviceFinderHub.finder(new Service("NS", "SERVICE")).orElseThrow(() -> new IllegalStateException("Finder should be present"));
        Optional dynamicServiceNode = dynamicServiceFinder.get(null, (criteria, serviceRegistry) -> serviceRegistry.nodeList());
        Assertions.assertTrue((boolean)dynamicServiceNode.isPresent());
        Assertions.assertEquals((Object)"HOST", (Object)((ServiceNode)dynamicServiceNode.get()).getHost());
        Assertions.assertEquals((int)0, (int)((ServiceNode)dynamicServiceNode.get()).getPort());
    }

    @Test
    void testDynamicServiceAdditionAsync() throws InterruptedException {
        this.serviceFinderHub.start();
        this.serviceFinderHub.buildFinder(new Service("NS", "SERVICE_NAME"));
        Optional finderOpt = this.serviceFinderHub.finder(new Service("NS", "SERVICE_NAME"));
        Assertions.assertFalse((boolean)finderOpt.isPresent(), (String)"Finders will not be availbale immediately");
        Thread.sleep(1000L);
        Optional finderAfterWaitOpt = this.serviceFinderHub.finder(new Service("NS", "SERVICE_NAME"));
        Assertions.assertTrue((boolean)finderAfterWaitOpt.isPresent(), (String)"Finders should be availble after some time");
    }

    @Test
    void testDynamicServiceAdditionWithNonDynamicDataSource() {
        ServiceFinderHub serviceFinderHub = new ServiceFinderHub((ServiceDataSource)new StaticDataSource(new HashSet()), service -> ((TestServiceFinderBuilder)((TestServiceFinderBuilder)((TestServiceFinderBuilder)new TestServiceFinderBuilder().withNamespace(service.getNamespace())).withServiceName(service.getServiceName())).withDeserializer((Deserializer)new Deserializer<TestNodeData>(){})).build());
        serviceFinderHub.start();
        try {
            CompletableFuture future = serviceFinderHub.buildFinder(new Service("NS", "SERVICE_NAME"));
            future.join();
            Assertions.fail((String)"Exception should have been thrown");
        }
        catch (Exception exception) {
            Assertions.assertTrue((boolean)(exception instanceof UnsupportedOperationException), (String)"Unsupported exception should be thrown");
        }
    }

    private static class TestServiceFinderBuilder
    extends BaseServiceFinderBuilder<TestNodeData, MapBasedServiceRegistry<TestNodeData>, ServiceFinder<TestNodeData, MapBasedServiceRegistry<TestNodeData>>, TestServiceFinderBuilder, Deserializer<TestNodeData>> {
        private TestServiceFinderBuilder() {
        }

        public ServiceFinder<TestNodeData, MapBasedServiceRegistry<TestNodeData>> build() {
            ServiceFinder bf = this.buildFinder();
            bf.start();
            return bf;
        }

        protected NodeDataSource<TestNodeData, Deserializer<TestNodeData>> dataSource(Service service) {
            return new TestNodeDataSource();
        }

        protected ServiceFinder<TestNodeData, MapBasedServiceRegistry<TestNodeData>> buildFinder(Service service, ShardSelector<TestNodeData, MapBasedServiceRegistry<TestNodeData>> shardSelector, ServiceNodeSelector<TestNodeData> nodeSelector) {
            if (null == shardSelector) {
                shardSelector = new MatchingShardSelector();
            }
            return new SimpleShardedServiceFinder(new MapBasedServiceRegistry(service), (ShardSelector)shardSelector, nodeSelector);
        }

        private static class TestNodeDataSource
        implements NodeDataSource<TestNodeData, Deserializer<TestNodeData>> {
            private TestNodeDataSource() {
            }

            public Optional<List<ServiceNode<TestNodeData>>> refresh(Deserializer<TestNodeData> deserializer) {
                ArrayList<ServiceNode> list = new ArrayList<ServiceNode>();
                list.add(new ServiceNode("HOST", 0, (Object)TestNodeData.builder().shardId(1).build(), HealthcheckStatus.healthy, 10L, "HTTP"));
                return Optional.of(list);
            }

            public void start() {
            }

            public void ensureConnected() {
            }

            public void stop() {
            }

            public boolean isActive() {
                return true;
            }
        }
    }
}

