/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.finder;

import io.appform.ranger.core.finder.SimpleUnshardedServiceFinder;
import io.appform.ranger.core.finder.serviceregistry.ListBasedServiceRegistry;
import io.appform.ranger.core.finder.shardselector.ListShardSelector;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.core.units.TestNodeData;
import io.appform.ranger.core.utils.RangerTestUtils;
import io.appform.ranger.core.utils.RegistryTestUtils;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UnshardedClusterFinderTest {
    UnshardedClusterFinderTest() {
    }

    @Test
    void unshardedClusterFinder() {
        ListBasedServiceRegistry<TestNodeData> unshardedRegistry = RegistryTestUtils.getUnshardedRegistry();
        ListShardSelector shardSelector = new ListShardSelector();
        SimpleUnshardedServiceFinder simpleUnshardedServiceFinder = new SimpleUnshardedServiceFinder(unshardedRegistry, (ShardSelector)shardSelector, (ServiceNodeSelector)new TestUnshardedNodeSelector());
        Optional serviceNode = simpleUnshardedServiceFinder.get(RangerTestUtils.getCriteria(1));
        Assertions.assertTrue((boolean)serviceNode.isPresent());
        Assertions.assertEquals((Object)"localhost-1", (Object)((ServiceNode)serviceNode.get()).getHost());
    }

    static class TestUnshardedNodeSelector
    implements ServiceNodeSelector<TestNodeData> {
        TestUnshardedNodeSelector() {
        }

        public ServiceNode<TestNodeData> select(List<ServiceNode<TestNodeData>> serviceNodes) {
            return serviceNodes.isEmpty() ? null : serviceNodes.get(0);
        }
    }
}

