/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FinderUtils {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinderUtils.class);

    public static <T> List<ServiceNode<T>> filterValidNodes(Service service, Collection<ServiceNode<T>> serviceNodes, long healthcheckZombieCheckThresholdTime) {
        return serviceNodes.stream().filter(serviceNode -> FinderUtils.isValidNode(service, healthcheckZombieCheckThresholdTime, serviceNode)).collect(Collectors.toList());
    }

    public static <T> boolean isValidNode(Service service, long healthcheckZombieCheckThresholdTime, ServiceNode<T> serviceNode) {
        if (null == serviceNode) {
            return false;
        }
        if (HealthcheckStatus.healthy != serviceNode.getHealthcheckStatus()) {
            log.debug("Unhealthy node [{}:{}] found for [{}]", new Object[]{serviceNode.getHost(), serviceNode.getPort(), service.getServiceName()});
            return false;
        }
        if (serviceNode.getLastUpdatedTimeStamp() < healthcheckZombieCheckThresholdTime) {
            log.warn("Zombie node [{}:{}] found for [{}]", new Object[]{serviceNode.getHost(), serviceNode.getPort(), service.getServiceName()});
            return false;
        }
        return true;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private FinderUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

