/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.signals;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.signals.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledSignal<T>
extends Signal<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduledSignal.class);
    private final String name;
    private final long refreshIntervalMillis;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> scheduledFuture = null;

    public ScheduledSignal(Service service, Supplier<T> signalDataGenerator, List<Consumer<T>> consumers, long refreshIntervalMillis) {
        super(signalDataGenerator, consumers);
        this.name = String.format("timer-%s-%s", service.getNamespace(), service.getServiceName());
        this.refreshIntervalMillis = refreshIntervalMillis;
    }

    public ScheduledSignal(String name, Supplier<T> signalDataGenerator, List<Consumer<T>> consumers, long refreshIntervalMillis) {
        super(signalDataGenerator, consumers);
        this.name = name;
        this.refreshIntervalMillis = refreshIntervalMillis;
    }

    @Override
    public final void start() {
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.onSignalReceived();
            }
            catch (Exception e) {
                log.error("Error delivering signal for:" + this.name, (Throwable)e);
            }
        }, 0L, this.refreshIntervalMillis, TimeUnit.MILLISECONDS);
        log.info("Started scheduled signal generator: {}", (Object)this.name);
    }

    @Override
    public final void stop() {
        if (null != this.scheduledFuture) {
            this.scheduledFuture.cancel(true);
        }
        log.info("Stopped scheduled signal generator: {}", (Object)this.name);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> ScheduledSignalBuilder<T> builder() {
        return new ScheduledSignalBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ScheduledSignalBuilder<T> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Service service;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Supplier<T> signalDataGenerator;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Consumer<T>> consumers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long refreshIntervalMillis;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ScheduledSignalBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScheduledSignalBuilder<T> service(Service service) {
            this.service = service;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScheduledSignalBuilder<T> signalDataGenerator(Supplier<T> signalDataGenerator) {
            this.signalDataGenerator = signalDataGenerator;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScheduledSignalBuilder<T> consumer(Consumer<T> consumer) {
            if (this.consumers == null) {
                this.consumers = new ArrayList();
            }
            this.consumers.add(consumer);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScheduledSignalBuilder<T> consumers(Collection<? extends Consumer<T>> consumers) {
            if (consumers == null) {
                throw new NullPointerException("consumers cannot be null");
            }
            if (this.consumers == null) {
                this.consumers = new ArrayList();
            }
            this.consumers.addAll(consumers);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScheduledSignalBuilder<T> clearConsumers() {
            if (this.consumers != null) {
                this.consumers.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScheduledSignalBuilder<T> refreshIntervalMillis(long refreshIntervalMillis) {
            this.refreshIntervalMillis = refreshIntervalMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScheduledSignal<T> build() {
            List consumers;
            switch (this.consumers == null ? 0 : this.consumers.size()) {
                case 0: {
                    consumers = Collections.emptyList();
                    break;
                }
                case 1: {
                    consumers = Collections.singletonList(this.consumers.get(0));
                    break;
                }
                default: {
                    consumers = Collections.unmodifiableList(new ArrayList<Consumer<T>>(this.consumers));
                }
            }
            return new ScheduledSignal<T>(this.service, this.signalDataGenerator, consumers, this.refreshIntervalMillis);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ScheduledSignal.ScheduledSignalBuilder(service=" + this.service + ", signalDataGenerator=" + this.signalDataGenerator + ", consumers=" + this.consumers + ", refreshIntervalMillis=" + this.refreshIntervalMillis + ")";
        }
    }
}

