/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.healthservice.monitor.sample;

import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.core.healthservice.TimeEntity;
import io.appform.ranger.core.healthservice.monitor.IsolatedHealthMonitor;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class RotationStatusMonitor
extends IsolatedHealthMonitor<HealthcheckStatus> {
    private final String filePath;

    public RotationStatusMonitor(String filePath) {
        this(new TimeEntity(1L, TimeUnit.SECONDS), filePath);
    }

    public RotationStatusMonitor(TimeEntity timeEntity, String filePath) {
        super(RotationStatusMonitor.class.getSimpleName(), timeEntity);
        this.filePath = filePath;
    }

    public RotationStatusMonitor(TimeEntity timeEntity, long stalenessAllowedInMillis, String filePath) {
        super(RotationStatusMonitor.class.getSimpleName(), timeEntity, stalenessAllowedInMillis);
        this.filePath = filePath;
    }

    @Override
    public HealthcheckStatus monitor() {
        File file = new File(this.filePath);
        return file.exists() ? HealthcheckStatus.healthy : HealthcheckStatus.unhealthy;
    }
}

