/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.healthservice.monitor.sample;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.core.healthservice.TimeEntity;
import io.appform.ranger.core.healthservice.monitor.IsolatedHealthMonitor;
import io.appform.ranger.core.healthservice.monitor.RollingWindowHealthQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingCheckMonitor
extends IsolatedHealthMonitor<HealthcheckStatus> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PingCheckMonitor.class);
    private final HttpRequest httpRequest;
    private final String host;
    private final ExecutorService executorService;
    private final Integer pingTimeoutInMilliseconds;
    private final CloseableHttpClient httpClient;
    private final int port;
    private final RollingWindowHealthQueue rollingWindowHealthQueue;

    public PingCheckMonitor(TimeEntity timeEntity, HttpRequest httpRequest, Integer pingTimeoutInMilliseconds, Integer pingWindowSize, Integer maxFailures, String host, Integer port) {
        super(PingCheckMonitor.class.getSimpleName(), timeEntity);
        this.httpRequest = httpRequest;
        this.pingTimeoutInMilliseconds = pingTimeoutInMilliseconds;
        this.host = host;
        this.port = port;
        this.rollingWindowHealthQueue = new RollingWindowHealthQueue(pingWindowSize, maxFailures);
        this.executorService = Executors.newSingleThreadExecutor();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxPerRoute(new HttpRoute(new HttpHost(host, port.intValue())), 2);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    @Override
    public HealthcheckStatus monitor() {
        log.debug("Running ping monitor :{} with HttpRequest:{} on host:{} port:{}", new Object[]{this.name, this.httpRequest, this.host, this.port});
        Future<Boolean> futurePingResponse = this.executorService.submit(this::healthPing);
        try {
            Boolean pingSuccessful = futurePingResponse.get(this.pingTimeoutInMilliseconds.intValue(), TimeUnit.MILLISECONDS);
            return this.getRollingWindowHealthcheckStatus(pingSuccessful != false ? HealthcheckStatus.healthy : HealthcheckStatus.unhealthy);
        }
        catch (InterruptedException e) {
            log.error("Request thread interrupted");
            Thread.currentThread().interrupt();
            return this.getRollingWindowHealthcheckStatus(HealthcheckStatus.unhealthy);
        }
        catch (ExecutionException | TimeoutException e) {
            log.error("Ping monitor failed:{} with HttpRequest:{} on host:{} port:{}", new Object[]{this.name, this.httpRequest, this.host, this.port});
            log.error("Error running ping monitor: ", (Throwable)e);
            return this.getRollingWindowHealthcheckStatus(HealthcheckStatus.unhealthy);
        }
    }

    private HealthcheckStatus getRollingWindowHealthcheckStatus(HealthcheckStatus healthy) {
        if (this.rollingWindowHealthQueue.checkInRollingWindow(healthy)) {
            return HealthcheckStatus.healthy;
        }
        log.info("{} is marking itself unhealthy since the current rolling window frame contains many failures (> threshold)). Was pinging on HttpRequest:{} on host:{} port:{}", new Object[]{this.name, this.httpRequest, this.host, this.port});
        return HealthcheckStatus.unhealthy;
    }

    private boolean healthPing() {
        try {
            log.debug("executing http HttpRequest: {}, host:{}, port:{}", new Object[]{this.httpRequest, this.host, this.port});
            CloseableHttpResponse response = this.httpClient.execute(new HttpHost(this.host, this.port), this.httpRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                log.error("Error while executing Ping Test. HttpRequest: {}, host:{}, port:{}, reason:{}", new Object[]{this.httpRequest, this.host, this.port, response.getStatusLine().getReasonPhrase()});
                response.close();
                return false;
            }
            response.close();
            return true;
        }
        catch (Exception e) {
            log.error("Exception while executing HttpRequest: ", (Throwable)e);
            return false;
        }
    }
}

