/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.finderhub;

import com.google.common.base.Preconditions;
import io.appform.ranger.core.finderhub.ServiceDataSource;
import io.appform.ranger.core.finderhub.ServiceFinderFactory;
import io.appform.ranger.core.finderhub.ServiceFinderHub;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.core.signals.ScheduledSignal;
import io.appform.ranger.core.signals.Signal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public abstract class ServiceFinderHubBuilder<T, R extends ServiceRegistry<T>> {
    private ServiceDataSource serviceDataSource;
    private ServiceFinderFactory<T, R> serviceFinderFactory;
    private long refreshFrequencyMs = 10000L;
    private final List<Consumer<Void>> extraStartSignalConsumers = new ArrayList<Consumer<Void>>();
    private final List<Consumer<Void>> extraStopSignalConsumers = new ArrayList<Consumer<Void>>();
    private final List<Signal<Void>> extraRefreshSignals = new ArrayList<Signal<Void>>();

    public ServiceFinderHubBuilder<T, R> withServiceDataSource(ServiceDataSource serviceDataSource) {
        this.serviceDataSource = serviceDataSource;
        return this;
    }

    public ServiceFinderHubBuilder<T, R> withServiceFinderFactory(ServiceFinderFactory<T, R> serviceFinderFactory) {
        this.serviceFinderFactory = serviceFinderFactory;
        return this;
    }

    public ServiceFinderHubBuilder<T, R> withRefreshFrequencyMs(long refreshFrequencyMs) {
        this.refreshFrequencyMs = refreshFrequencyMs;
        return this;
    }

    public ServiceFinderHubBuilder<T, R> withExtraStartSignalConsumer(Consumer<Void> consumer) {
        this.extraStartSignalConsumers.add(consumer);
        return this;
    }

    public ServiceFinderHubBuilder<T, R> withExtraStopSignalConsumer(Consumer<Void> consumer) {
        this.extraStopSignalConsumers.add(consumer);
        return this;
    }

    public ServiceFinderHubBuilder<T, R> withExtraRefreshSignal(Signal<Void> extraRefreshSignal) {
        this.extraRefreshSignals.add(extraRefreshSignal);
        return this;
    }

    public ServiceFinderHub<T, R> build() {
        this.preBuild();
        Preconditions.checkNotNull((Object)this.serviceDataSource, (Object)"Provide a non-null service data source");
        Preconditions.checkNotNull(this.serviceFinderFactory, (Object)"Provide a non-null service finder factory");
        ServiceFinderHub<T, R> hub = new ServiceFinderHub<T, R>(this.serviceDataSource, this.serviceFinderFactory);
        ScheduledSignal<Void> refreshSignal = new ScheduledSignal<Void>("service-hub-refresh-timer", () -> null, Collections.emptyList(), this.refreshFrequencyMs);
        hub.registerUpdateSignal(refreshSignal);
        this.extraRefreshSignals.forEach(hub::registerUpdateSignal);
        hub.getStartSignal().registerConsumer(x -> this.serviceDataSource.start()).registerConsumer(x -> refreshSignal.start()).registerConsumers(this.extraStartSignalConsumers);
        hub.getStopSignal().registerConsumers(this.extraStopSignalConsumers).registerConsumer(x -> refreshSignal.stop()).registerConsumer(x -> this.serviceDataSource.stop());
        this.postBuild(hub);
        return hub;
    }

    protected abstract void preBuild();

    protected abstract void postBuild(ServiceFinderHub<T, R> var1);
}

