/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.finder.serviceregistry;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

public class ListBasedServiceRegistry<T>
extends ServiceRegistry<T> {
    private final AtomicReference<List<ServiceNode<T>>> nodes = new AtomicReference();

    public ListBasedServiceRegistry(Service service) {
        super(service);
    }

    @Override
    public List<ServiceNode<T>> nodeList() {
        List<ServiceNode<T>> nodeList = this.nodes.get();
        return null == nodeList ? Collections.emptyList() : nodeList;
    }

    @Override
    public void update(List<ServiceNode<T>> serviceNodes) {
        this.nodes.set((List<ServiceNode<T>>)ImmutableList.copyOf(serviceNodes));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListBasedServiceRegistry)) {
            return false;
        }
        ListBasedServiceRegistry other = (ListBasedServiceRegistry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtomicReference<List<ServiceNode<T>>> this$nodes = this.nodes;
        AtomicReference<List<ServiceNode<T>>> other$nodes = other.nodes;
        return !(this$nodes == null ? other$nodes != null : !this$nodes.equals(other$nodes));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ListBasedServiceRegistry;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AtomicReference<List<ServiceNode<T>>> $nodes = this.nodes;
        result = result * 59 + ($nodes == null ? 43 : $nodes.hashCode());
        return result;
    }
}

