/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.healthservice.monitor.sample;

import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import io.appform.ranger.core.healthservice.TimeEntity;
import io.appform.ranger.core.healthservice.monitor.IsolatedHealthMonitor;

public abstract class CountMonitor
extends IsolatedHealthMonitor {
    private Integer threshold;
    private CheckSign checkSign;

    public CountMonitor(String name, CheckSign checkSign, Integer threshold, TimeEntity timeEntity) {
        super(name, timeEntity);
        this.checkSign = checkSign;
        this.threshold = threshold;
    }

    @Override
    public HealthcheckStatus monitor() {
        long count = this.getCount().longValue();
        switch (this.checkSign) {
            case LESSER_THAN: {
                if (count < (long)this.threshold.intValue()) {
                    return HealthcheckStatus.healthy;
                }
                return HealthcheckStatus.unhealthy;
            }
            case LESSER_THAN_EQUALTO: {
                if (count <= (long)this.threshold.intValue()) {
                    return HealthcheckStatus.healthy;
                }
                return HealthcheckStatus.unhealthy;
            }
            case GREATER_THAN: {
                if (count > (long)this.threshold.intValue()) {
                    return HealthcheckStatus.healthy;
                }
                return HealthcheckStatus.unhealthy;
            }
        }
        if (count >= (long)this.threshold.intValue()) {
            return HealthcheckStatus.healthy;
        }
        return HealthcheckStatus.unhealthy;
    }

    public abstract Number getCount();

    public static enum CheckSign {
        LESSER_THAN,
        LESSER_THAN_EQUALTO,
        GREATER_THAN,
        GREATER_THAN_EQUALTO;

    }
}

