/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.healthservice.monitor;

import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;

public class RollingWindowHealthQueue {
    private Integer rollingWindowSize;
    private Integer maxFailures;
    private final AtomicReference<Integer> currentFailuresCount = new AtomicReference();
    private Queue<HealthcheckStatus> statusQueue;

    public RollingWindowHealthQueue(Integer rollingWindowSize, Integer maxFailures) {
        this.rollingWindowSize = rollingWindowSize;
        this.maxFailures = maxFailures;
        this.currentFailuresCount.set(0);
        this.statusQueue = new LinkedList<HealthcheckStatus>();
        if (rollingWindowSize <= 0) {
            throw new UnsupportedOperationException("rollingWindowSize cant be <= 0");
        }
        if (maxFailures > rollingWindowSize) {
            throw new UnsupportedOperationException("maxFailures cant be greater than the rollingWindowSize");
        }
    }

    public boolean checkInRollingWindow(HealthcheckStatus currentHealthStatus) {
        if (currentHealthStatus == HealthcheckStatus.healthy) {
            HealthcheckStatus oldestStatus;
            if (this.statusQueue.size() == this.rollingWindowSize.intValue() && (oldestStatus = this.statusQueue.remove()) == HealthcheckStatus.unhealthy) {
                this.currentFailuresCount.getAndSet(this.currentFailuresCount.get() - 1);
            }
            this.statusQueue.add(currentHealthStatus);
        } else {
            if (this.statusQueue.size() == this.rollingWindowSize.intValue()) {
                HealthcheckStatus oldestStatus = this.statusQueue.remove();
                if (oldestStatus == HealthcheckStatus.healthy) {
                    this.currentFailuresCount.getAndSet(this.currentFailuresCount.get() + 1);
                }
            } else {
                this.currentFailuresCount.getAndSet(this.currentFailuresCount.get() + 1);
            }
            this.statusQueue.add(currentHealthStatus);
        }
        return this.currentFailuresCount.get() < this.maxFailures;
    }
}

