/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.healthcheck;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.healthcheck.Healthcheck;
import io.appform.ranger.core.healthcheck.HealthcheckResult;
import io.appform.ranger.core.healthcheck.HealthcheckStatus;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthChecker
implements Supplier<HealthcheckResult> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthChecker.class);
    private final List<Healthcheck> healthChecks;
    private final int staleUpdateThreshold;
    private HealthcheckStatus lastHealthcheckStatus;
    private long lastUpdatedTime;

    public HealthChecker(List<Healthcheck> healthChecks, int staleUpdateThreshold) {
        this.healthChecks = healthChecks;
        this.staleUpdateThreshold = staleUpdateThreshold;
    }

    @Override
    public HealthcheckResult get() {
        if (this.refreshHealth()) {
            return HealthcheckResult.builder().status(this.lastHealthcheckStatus).updatedTime(this.lastUpdatedTime).build();
        }
        return null;
    }

    private boolean refreshHealth() {
        HealthcheckStatus healthcheckStatus = HealthcheckStatus.unhealthy;
        for (Healthcheck healthcheck : this.healthChecks) {
            try {
                healthcheckStatus = healthcheck.check();
            }
            catch (Throwable t) {
                log.error("Error running healthcheck. Setting node to unhealthy", t);
                healthcheckStatus = HealthcheckStatus.unhealthy;
            }
            if (HealthcheckStatus.unhealthy != healthcheckStatus) continue;
            break;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastHealthcheckStatus == null || currentTime - this.lastUpdatedTime > (long)this.staleUpdateThreshold || this.lastHealthcheckStatus != healthcheckStatus) {
            this.lastUpdatedTime = currentTime;
            this.lastHealthcheckStatus = healthcheckStatus;
            return true;
        }
        this.lastHealthcheckStatus = healthcheckStatus;
        return false;
    }
}

