/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.finder.serviceregistry;

import com.google.common.collect.ImmutableList;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ListBasedServiceRegistry<T>
extends ServiceRegistry<T> {
    private final AtomicReference<List<ServiceNode<T>>> nodes = new AtomicReference();

    public ListBasedServiceRegistry(Service service) {
        super(service);
    }

    @Override
    public List<ServiceNode<T>> nodeList() {
        List<ServiceNode<T>> nodeList = this.nodes.get();
        return null == nodeList ? Collections.emptyList() : nodeList;
    }

    @Override
    public void updateNodes(List<ServiceNode<T>> serviceNodes) {
        this.nodes.set((List<ServiceNode<T>>)ImmutableList.copyOf(serviceNodes));
    }
}

