/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.finder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.core.model.ShardSelector;
import io.appform.ranger.core.signals.ExternalTriggeredSignal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceFinder<T, ServiceRegistryType extends ServiceRegistry<T>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceFinder.class);
    private final ServiceRegistryType serviceRegistry;
    private final ShardSelector<T, ServiceRegistryType> shardSelector;
    private final ServiceNodeSelector<T> nodeSelector;
    private final ExternalTriggeredSignal<Void> startSignal = new ExternalTriggeredSignal<Void>(() -> null, Collections.emptyList());
    private final ExternalTriggeredSignal<Void> stopSignal = new ExternalTriggeredSignal<Void>(() -> null, Collections.emptyList());

    protected ServiceFinder(ServiceRegistryType serviceRegistry, ShardSelector<T, ServiceRegistryType> shardSelector, ServiceNodeSelector<T> nodeSelector) {
        this.serviceRegistry = serviceRegistry;
        this.shardSelector = shardSelector;
        this.nodeSelector = nodeSelector;
    }

    public Optional<ServiceNode<T>> get(Predicate<T> criteria) {
        List<ServiceNode<T>> nodes = this.shardSelector.nodes(criteria, this.serviceRegistry);
        return null == nodes || nodes.isEmpty() ? Optional.empty() : Optional.of(this.nodeSelector.select(nodes));
    }

    public List<ServiceNode<T>> getAll(Predicate<T> criteria) {
        return this.shardSelector.nodes(criteria, this.serviceRegistry);
    }

    public void start() {
        this.startSignal.trigger();
    }

    public void stop() {
        this.stopSignal.trigger();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ServiceRegistryType getServiceRegistry() {
        return this.serviceRegistry;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExternalTriggeredSignal<Void> getStartSignal() {
        return this.startSignal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExternalTriggeredSignal<Void> getStopSignal() {
        return this.stopSignal;
    }
}

