/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.core.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.core.finder.ServiceFinder;
import io.appform.ranger.core.finderhub.ServiceFinderHub;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.core.units.TestNodeData;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import lombok.Generated;
import org.awaitility.Awaitility;

public final class RangerTestUtils {
    static String TEST_NAMESPACE = "test";
    static String TEST_SERVICE = "test-service";
    public static Service service = Service.builder().namespace(TEST_NAMESPACE).serviceName(TEST_SERVICE).build();

    public static Predicate<TestNodeData> getCriteria(int shardId) {
        return nodeData -> nodeData.getShardId() == shardId;
    }

    public static Service getService(String namespace, String serviceName) {
        return Service.builder().serviceName(serviceName).namespace(namespace).build();
    }

    public static void sleepUntil(int numSeconds) {
        Awaitility.await().pollDelay(Duration.ofSeconds(numSeconds)).until(() -> true);
    }

    public static void sleepUntil(int numSeconds, Callable<Boolean> conditionEvaluator) {
        Awaitility.await().pollDelay(Duration.ofSeconds(numSeconds)).until(conditionEvaluator);
    }

    public static <T, R extends ServiceRegistry<T>> void sleepUntilFinderStarts(ServiceFinder<T, R> finder) {
        Awaitility.await().pollDelay(Duration.ofSeconds(3L)).until(() -> !finder.getServiceRegistry().nodeList().isEmpty());
    }

    public static <T, R extends ServiceRegistry<T>> void sleepUntilHubStarts(ServiceFinderHub<T, R> hub) {
        Awaitility.await().pollDelay(Duration.ofSeconds(3L)).until(() -> hub.getServiceDataSource() != null && ((Map)hub.getFinders().get()).values().stream().noneMatch(finder -> finder.getServiceRegistry().nodeList().isEmpty()));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private RangerTestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

