/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.RangerHubClient;
import io.appform.ranger.client.utils.CriteriaUtils;
import io.appform.ranger.core.finderhub.ServiceDataSource;
import io.appform.ranger.core.finderhub.ServiceFinderFactory;
import io.appform.ranger.core.finderhub.ServiceFinderHub;
import io.appform.ranger.core.model.Deserializer;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.core.model.ShardSelector;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRangerHubClient<T, R extends ServiceRegistry<T>, D extends Deserializer<T>>
implements RangerHubClient<T, R> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRangerHubClient.class);
    private final String namespace;
    private final ObjectMapper mapper;
    private final D deserializer;
    private final Predicate<T> initialCriteria;
    private final boolean alwaysUseInitialCriteria;
    private int nodeRefreshTimeMs;
    private ServiceFinderHub<T, R> hub;
    private ServiceDataSource serviceDataSource;

    @Override
    public void start() {
        Preconditions.checkNotNull((Object)this.mapper, (Object)"Mapper can't be null");
        Preconditions.checkNotNull((Object)this.namespace, (Object)"namespace can't be null");
        Preconditions.checkNotNull(this.deserializer, (Object)"deserializer can't be null");
        if (this.nodeRefreshTimeMs < 5000) {
            log.warn("Node info update interval too low: {} ms. Has been upgraded to {} ms ", (Object)this.nodeRefreshTimeMs, (Object)5000);
        }
        this.nodeRefreshTimeMs = Math.max(5000, this.nodeRefreshTimeMs);
        if (null == this.serviceDataSource) {
            this.serviceDataSource = this.getDefaultDataSource();
        }
        this.hub = this.buildHub();
        this.hub.start();
    }

    @Override
    public void stop() {
        if (null != this.hub) {
            this.hub.stop();
        }
    }

    @Override
    public Optional<ServiceNode<T>> getNode(Service service) {
        return this.getNode(service, this.initialCriteria);
    }

    @Override
    public List<ServiceNode<T>> getAllNodes(Service service) {
        return this.getAllNodes(service, this.initialCriteria);
    }

    @Override
    public Optional<ServiceNode<T>> getNode(Service service, Predicate<T> criteria) {
        return this.getNode(service, criteria, null);
    }

    @Override
    public Optional<ServiceNode<T>> getNode(Service service, Predicate<T> criteria, ShardSelector<T, R> shardSelector) {
        return this.getNode(service, criteria, shardSelector, null);
    }

    @Override
    public Optional<ServiceNode<T>> getNode(Service service, Predicate<T> criteria, ShardSelector<T, R> shardSelector, ServiceNodeSelector<T> nodeSelector) {
        return this.getHub().finder(service).flatMap(trServiceFinder -> trServiceFinder.get(CriteriaUtils.getCriteria(this.alwaysUseInitialCriteria, this.initialCriteria, criteria), shardSelector, nodeSelector));
    }

    @Override
    public List<ServiceNode<T>> getAllNodes(Service service, Predicate<T> criteria) {
        return this.getAllNodes(service, criteria, null);
    }

    @Override
    public List<ServiceNode<T>> getAllNodes(Service service, Predicate<T> criteria, ShardSelector<T, R> shardSelector) {
        return this.getHub().finder(service).map(trServiceFinder -> trServiceFinder.getAll(CriteriaUtils.getCriteria(this.alwaysUseInitialCriteria, this.initialCriteria, criteria), shardSelector)).orElse(Collections.emptyList());
    }

    @Override
    public Collection<Service> getRegisteredServices() {
        try {
            return this.getHub().getServiceDataSource().services();
        }
        catch (Exception e) {
            log.error("Call to the hub failed with exception, {}", (Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    @Override
    public CompletableFuture<?> addService(Service service) {
        if (this.hub == null) {
            throw new IllegalStateException("Hub not started yet. Call .start()");
        }
        return this.hub.buildFinder(service);
    }

    protected abstract ServiceDataSource getDefaultDataSource();

    protected abstract ServiceFinderFactory<T, R> getFinderFactory();

    protected abstract ServiceFinderHub<T, R> buildHub();

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected AbstractRangerHubClient(AbstractRangerHubClientBuilder<T, R, D, ?, ?> b) {
        this.namespace = b.namespace;
        this.mapper = b.mapper;
        this.deserializer = b.deserializer;
        this.initialCriteria = b.initialCriteria;
        this.alwaysUseInitialCriteria = b.alwaysUseInitialCriteria;
        this.nodeRefreshTimeMs = b.nodeRefreshTimeMs;
        this.hub = b.hub;
        this.serviceDataSource = b.serviceDataSource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public D getDeserializer() {
        return this.deserializer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Predicate<T> getInitialCriteria() {
        return this.initialCriteria;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAlwaysUseInitialCriteria() {
        return this.alwaysUseInitialCriteria;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getNodeRefreshTimeMs() {
        return this.nodeRefreshTimeMs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ServiceFinderHub<T, R> getHub() {
        return this.hub;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ServiceDataSource getServiceDataSource() {
        return this.serviceDataSource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static abstract class AbstractRangerHubClientBuilder<T, R extends ServiceRegistry<T>, D extends Deserializer<T>, C extends AbstractRangerHubClient<T, R, D>, B extends AbstractRangerHubClientBuilder<T, R, D, C, B>> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String namespace;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ObjectMapper mapper;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private D deserializer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Predicate<T> initialCriteria;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean alwaysUseInitialCriteria;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int nodeRefreshTimeMs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ServiceFinderHub<T, R> hub;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ServiceDataSource serviceDataSource;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected abstract B self();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public abstract C build();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B deserializer(D deserializer) {
            this.deserializer = deserializer;
            return this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B initialCriteria(Predicate<T> initialCriteria) {
            this.initialCriteria = initialCriteria;
            return this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B alwaysUseInitialCriteria(boolean alwaysUseInitialCriteria) {
            this.alwaysUseInitialCriteria = alwaysUseInitialCriteria;
            return this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B nodeRefreshTimeMs(int nodeRefreshTimeMs) {
            this.nodeRefreshTimeMs = nodeRefreshTimeMs;
            return this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B hub(ServiceFinderHub<T, R> hub) {
            this.hub = hub;
            return this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B serviceDataSource(ServiceDataSource serviceDataSource) {
            this.serviceDataSource = serviceDataSource;
            return this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "AbstractRangerHubClient.AbstractRangerHubClientBuilder(namespace=" + this.namespace + ", mapper=" + this.mapper + ", deserializer=" + this.deserializer + ", initialCriteria=" + this.initialCriteria + ", alwaysUseInitialCriteria=" + this.alwaysUseInitialCriteria + ", nodeRefreshTimeMs=" + this.nodeRefreshTimeMs + ", hub=" + this.hub + ", serviceDataSource=" + this.serviceDataSource + ")";
        }
    }
}

