/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client;

import io.appform.ranger.client.utils.CriteriaUtils;
import io.appform.ranger.core.units.TestNodeData;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CriteriaUtilsTest {
    CriteriaUtilsTest() {
    }

    private Predicate<TestNodeData> getCriteria(int shardId) {
        return testNodeData -> testNodeData.getShardId() == shardId;
    }

    @Test
    void testGetCriteria() {
        Predicate<TestNodeData> initialCriteria = this.getCriteria(1);
        Predicate<TestNodeData> argCriteria = this.getCriteria(2);
        Predicate mergedCriteria = CriteriaUtils.getCriteria((boolean)true, initialCriteria, argCriteria);
        Assertions.assertFalse((boolean)mergedCriteria.test(TestNodeData.builder().shardId(1).build()));
        Assertions.assertFalse((boolean)mergedCriteria.test(TestNodeData.builder().shardId(2).build()));
        mergedCriteria = CriteriaUtils.getCriteria((boolean)false, initialCriteria, argCriteria);
        Assertions.assertFalse((boolean)mergedCriteria.test(TestNodeData.builder().shardId(1).build()));
        Assertions.assertTrue((boolean)mergedCriteria.test(TestNodeData.builder().shardId(2).build()));
    }
}

