/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.stubs.RangerTestHub;
import io.appform.ranger.client.utils.RangerHubTestUtils;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.units.TestNodeData;
import io.appform.ranger.core.utils.RangerTestUtils;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbstractRangerHubClientTest {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRangerHubClientTest.class);
    private static final Service service = RangerTestUtils.getService((String)"test-ns", (String)"test-s");

    AbstractRangerHubClientTest() {
    }

    @Test
    void testAbstractHubClient() {
        RangerTestHub testAbstractHub = RangerHubTestUtils.getTestHub();
        testAbstractHub.start();
        ServiceNode node = testAbstractHub.getNode(service).orElse(null);
        Assertions.assertNotNull((Object)node);
        Assertions.assertTrue((boolean)node.getHost().equalsIgnoreCase("localhost"));
        Assertions.assertEquals((int)9200, (int)node.getPort());
        Assertions.assertEquals((int)1, (int)((TestNodeData)node.getNodeData()).getShardId());
        Assertions.assertFalse((boolean)testAbstractHub.getNode(RangerTestUtils.getService((String)"test", (String)"test")).isPresent());
        Assertions.assertFalse((boolean)testAbstractHub.getNode(service, nodeData -> nodeData.getShardId() == 2).isPresent());
        Assertions.assertFalse((boolean)testAbstractHub.getNode(RangerTestUtils.getService((String)"test", (String)"test"), nodeData -> nodeData.getShardId() == 1).isPresent());
        testAbstractHub.stop();
    }

    @Test
    void testAbstractHubClientWithDataSource() {
        RangerTestHub testAbstractHub = RangerHubTestUtils.getTestHubWithDataSource();
        testAbstractHub.start();
        ServiceNode node = testAbstractHub.getNode(service).orElse(null);
        Assertions.assertNotNull((Object)node);
        Assertions.assertTrue((boolean)node.getHost().equalsIgnoreCase("localhost"));
        Assertions.assertEquals((int)9200, (int)node.getPort());
        Assertions.assertEquals((int)1, (int)((TestNodeData)node.getNodeData()).getShardId());
        Assertions.assertFalse((boolean)testAbstractHub.getNode(RangerTestUtils.getService((String)"test", (String)"test")).isPresent());
        Assertions.assertFalse((boolean)testAbstractHub.getNode(service, nodeData -> nodeData.getShardId() == 2).isPresent());
        Assertions.assertFalse((boolean)testAbstractHub.getNode(RangerTestUtils.getService((String)"test", (String)"test"), nodeData -> nodeData.getShardId() == 1).isPresent());
        testAbstractHub.stop();
    }
}

