/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.RangerClient;
import io.appform.ranger.client.utils.CriteriaUtils;
import io.appform.ranger.core.finder.ServiceFinder;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceNodeSelector;
import io.appform.ranger.core.model.ServiceRegistry;
import io.appform.ranger.core.model.ShardSelector;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;

public abstract class AbstractRangerClient<T, R extends ServiceRegistry<T>>
implements RangerClient<T, R> {
    private final Predicate<T> initialCriteria;
    private final boolean alwaysUseInitialCriteria;

    public abstract ServiceFinder<T, R> getServiceFinder();

    @Override
    public Optional<ServiceNode<T>> getNode() {
        return this.getNode(this.initialCriteria);
    }

    @Override
    public Optional<ServiceNode<T>> getNode(Predicate<T> criteria) {
        return this.getNode(criteria, null);
    }

    @Override
    public Optional<ServiceNode<T>> getNode(Predicate<T> criteria, ShardSelector<T, R> shardSelector) {
        return this.getNode(criteria, shardSelector, null);
    }

    @Override
    public Optional<ServiceNode<T>> getNode(Predicate<T> criteria, ShardSelector<T, R> shardSelector, ServiceNodeSelector<T> nodeSelector) {
        return this.getServiceFinder().get(CriteriaUtils.getCriteria(this.alwaysUseInitialCriteria, this.initialCriteria, criteria), shardSelector, nodeSelector);
    }

    @Override
    public List<ServiceNode<T>> getAllNodes() {
        return this.getAllNodes(this.initialCriteria);
    }

    @Override
    public List<ServiceNode<T>> getAllNodes(Predicate<T> criteria) {
        return this.getAllNodes(criteria, null);
    }

    @Override
    public List<ServiceNode<T>> getAllNodes(Predicate<T> criteria, ShardSelector<T, R> shardSelector) {
        return this.getServiceFinder().getAll(CriteriaUtils.getCriteria(this.alwaysUseInitialCriteria, this.initialCriteria, criteria), shardSelector);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected AbstractRangerClient(AbstractRangerClientBuilder<T, R, ?, ?> b) {
        this.initialCriteria = ((AbstractRangerClientBuilder)b).initialCriteria;
        this.alwaysUseInitialCriteria = ((AbstractRangerClientBuilder)b).alwaysUseInitialCriteria;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static abstract class AbstractRangerClientBuilder<T, R extends ServiceRegistry<T>, C extends AbstractRangerClient<T, R>, B extends AbstractRangerClientBuilder<T, R, C, B>> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Predicate<T> initialCriteria;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean alwaysUseInitialCriteria;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected abstract B self();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public abstract C build();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B initialCriteria(Predicate<T> initialCriteria) {
            this.initialCriteria = initialCriteria;
            return this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public B alwaysUseInitialCriteria(boolean alwaysUseInitialCriteria) {
            this.alwaysUseInitialCriteria = alwaysUseInitialCriteria;
            return this.self();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "AbstractRangerClient.AbstractRangerClientBuilder(initialCriteria=" + this.initialCriteria + ", alwaysUseInitialCriteria=" + this.alwaysUseInitialCriteria + ")";
        }
    }
}

