/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client;

import io.appform.ranger.client.utils.CriteriaUtils;
import io.appform.ranger.core.units.TestNodeData;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;

public class CriteriaUtilsTest {
    private Predicate<TestNodeData> getCriteria(int shardId) {
        return testNodeData -> testNodeData.getShardId() == shardId;
    }

    @Test
    public void testGetCriteria() {
        Predicate<TestNodeData> initialCriteria = this.getCriteria(1);
        Predicate<TestNodeData> argCriteria = this.getCriteria(2);
        Predicate mergedCriteria = CriteriaUtils.getCriteria((boolean)true, initialCriteria, argCriteria);
        Assert.assertFalse((boolean)mergedCriteria.test(TestNodeData.builder().shardId(1).build()));
        Assert.assertFalse((boolean)mergedCriteria.test(TestNodeData.builder().shardId(2).build()));
        mergedCriteria = CriteriaUtils.getCriteria((boolean)false, initialCriteria, argCriteria);
        Assert.assertFalse((boolean)mergedCriteria.test(TestNodeData.builder().shardId(1).build()));
        Assert.assertTrue((boolean)mergedCriteria.test(TestNodeData.builder().shardId(2).build()));
    }
}

