/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.RangerHubClient;
import io.appform.ranger.client.utils.CriteriaUtils;
import io.appform.ranger.core.finderhub.ServiceDataSource;
import io.appform.ranger.core.finderhub.ServiceFinderFactory;
import io.appform.ranger.core.finderhub.ServiceFinderHub;
import io.appform.ranger.core.model.Deserializer;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRangerHubClient<T, R extends ServiceRegistry<T>, D extends Deserializer<T>>
implements RangerHubClient<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRangerHubClient.class);
    private final String namespace;
    private final ObjectMapper mapper;
    private final D deserializer;
    private int nodeRefreshTimeMs;
    private ServiceFinderHub<T, R> hub;
    private final Predicate<T> initialCriteria;
    private final boolean alwaysUseInitialCriteria;

    protected AbstractRangerHubClient(String namespace, ObjectMapper mapper, int nodeRefreshTimeMs, Predicate<T> initialCriteria, D deserializer, boolean alwaysUseInitialCriteria) {
        this.namespace = namespace;
        this.mapper = mapper;
        this.nodeRefreshTimeMs = nodeRefreshTimeMs;
        this.initialCriteria = initialCriteria;
        this.deserializer = deserializer;
        this.alwaysUseInitialCriteria = alwaysUseInitialCriteria;
    }

    @Override
    public void start() {
        Preconditions.checkNotNull((Object)this.mapper, (Object)"Mapper can't be null");
        Preconditions.checkNotNull((Object)this.namespace, (Object)"namespace can't be null");
        Preconditions.checkNotNull(this.deserializer, (Object)"deserializer can't be null");
        if (this.nodeRefreshTimeMs < 5000) {
            log.warn("Node info update interval too low: {} ms. Has been upgraded to {} ms ", (Object)this.nodeRefreshTimeMs, (Object)5000);
        }
        this.nodeRefreshTimeMs = Math.max(5000, this.nodeRefreshTimeMs);
        this.hub = this.buildHub();
        this.hub.start();
    }

    @Override
    public void stop() {
        this.hub.stop();
    }

    @Override
    public Optional<ServiceNode<T>> getNode(Service service) {
        return this.getNode(service, this.initialCriteria);
    }

    @Override
    public List<ServiceNode<T>> getAllNodes(Service service) {
        return this.getAllNodes(service, this.initialCriteria);
    }

    @Override
    public Optional<ServiceNode<T>> getNode(Service service, Predicate<T> criteria) {
        return this.getHub().finder(service).flatMap(trServiceFinder -> trServiceFinder.get(CriteriaUtils.getCriteria(this.alwaysUseInitialCriteria, this.initialCriteria, criteria)));
    }

    @Override
    public List<ServiceNode<T>> getAllNodes(Service service, Predicate<T> criteria) {
        return this.getHub().finder(service).map(trServiceFinder -> trServiceFinder.getAll(CriteriaUtils.getCriteria(this.alwaysUseInitialCriteria, this.initialCriteria, criteria))).orElse(Collections.emptyList());
    }

    @Override
    public Collection<Service> getRegisteredServices() {
        try {
            return this.getHub().getServiceDataSource().services();
        }
        catch (Exception e) {
            log.error("Call to the hub failed with exception, {}", (Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    protected abstract ServiceFinderHub<T, R> buildHub();

    protected abstract ServiceDataSource buildServiceDataSource();

    protected abstract ServiceFinderFactory<T, R> buildFinderFactory();

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public D getDeserializer() {
        return this.deserializer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getNodeRefreshTimeMs() {
        return this.nodeRefreshTimeMs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ServiceFinderHub<T, R> getHub() {
        return this.hub;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Predicate<T> getInitialCriteria() {
        return this.initialCriteria;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAlwaysUseInitialCriteria() {
        return this.alwaysUseInitialCriteria;
    }
}

