/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client;

import io.appform.ranger.client.RangerClient;
import io.appform.ranger.client.utils.CriteriaUtils;
import io.appform.ranger.core.finder.ServiceFinder;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.model.ServiceRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class AbstractRangerClient<T, R extends ServiceRegistry<T>>
implements RangerClient<T> {
    private final Predicate<T> initialCriteria;
    private final boolean alwaysUseInitialCriteria;

    protected AbstractRangerClient(Predicate<T> initialCriteria, boolean alwaysUseInitialCriteria) {
        this.initialCriteria = initialCriteria;
        this.alwaysUseInitialCriteria = alwaysUseInitialCriteria;
    }

    public abstract ServiceFinder<T, R> getServiceFinder();

    @Override
    public Optional<ServiceNode<T>> getNode() {
        return this.getServiceFinder().get(this.initialCriteria);
    }

    @Override
    public Optional<ServiceNode<T>> getNode(Predicate<T> criteria) {
        return this.getServiceFinder().get(CriteriaUtils.getCriteria(this.alwaysUseInitialCriteria, this.initialCriteria, criteria));
    }

    @Override
    public List<ServiceNode<T>> getAllNodes() {
        return this.getServiceFinder().getAll(this.initialCriteria);
    }

    @Override
    public List<ServiceNode<T>> getAllNodes(Predicate<T> criteria) {
        return this.getServiceFinder().getAll(CriteriaUtils.getCriteria(this.alwaysUseInitialCriteria, this.initialCriteria, criteria));
    }
}

