/*
 * Decompiled with CFR 0.152.
 */
package io.appform.ranger.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appform.ranger.client.stubs.RangerTestHub;
import io.appform.ranger.client.utils.RangerHubTestUtils;
import io.appform.ranger.core.finderhub.ServiceFinderHub;
import io.appform.ranger.core.model.Service;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.units.TestNodeData;
import io.appform.ranger.core.utils.RangerTestUtils;
import lombok.Generated;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractRangerHubClientTest {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRangerHubClientTest.class);
    private static final Service service = RangerTestUtils.getService((String)"test-ns", (String)"test-s");

    @Test
    public void testAbstractHubClient() {
        RangerTestHub testAbstractHub = RangerHubTestUtils.getTestHub();
        testAbstractHub.start();
        RangerTestUtils.sleepUntilHubStarts((ServiceFinderHub)testAbstractHub.getHub());
        ServiceNode node = testAbstractHub.getNode(service).orElse(null);
        Assert.assertNotNull((Object)node);
        Assert.assertTrue((boolean)node.getHost().equalsIgnoreCase("localhost"));
        Assert.assertEquals((long)9200L, (long)node.getPort());
        Assert.assertEquals((long)1L, (long)((TestNodeData)node.getNodeData()).getShardId());
        Assert.assertFalse((boolean)testAbstractHub.getNode(RangerTestUtils.getService((String)"test", (String)"test")).isPresent());
        Assert.assertFalse((boolean)testAbstractHub.getNode(service, nodeData -> nodeData.getShardId() == 2).isPresent());
        Assert.assertFalse((boolean)testAbstractHub.getNode(RangerTestUtils.getService((String)"test", (String)"test"), nodeData -> nodeData.getShardId() == 1).isPresent());
        testAbstractHub.stop();
    }
}

