/*
 * Decompiled with CFR 0.152.
 */
package io.appform.idman.authcomponents.security;

import io.appform.idman.authcomponents.security.ServiceUserPrincipal;
import io.appform.idman.client.IdManClient;
import io.appform.idman.client.IdmanClientConfig;
import io.appform.idman.model.IdmanUser;
import io.appform.idman.model.TokenInfo;
import io.dropwizard.auth.Authenticator;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IdmanAuthenticator
implements Authenticator<String, ServiceUserPrincipal> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdmanAuthenticator.class);
    private final IdmanClientConfig config;
    private final IdManClient idManClient;

    @Inject
    public IdmanAuthenticator(IdmanClientConfig config, IdManClient idManClient) {
        this.config = config;
        this.idManClient = idManClient;
    }

    public Optional<ServiceUserPrincipal> authenticate(String token) {
        IdmanUser serviceSessionUser = this.idManClient.validateToken(this.config.getServiceId(), token).map(TokenInfo::getUser).orElse(null);
        if (serviceSessionUser == null) {
            log.warn("authentication_failed::invalid_session token:{}", (Object)token);
            return Optional.empty();
        }
        log.debug("authentication_success userId:{} tokenId:{}", (Object)serviceSessionUser.getUser().getId(), (Object)serviceSessionUser.getSessionId());
        return Optional.of(new ServiceUserPrincipal(serviceSessionUser));
    }
}

