/*
 * Decompiled with CFR 0.152.
 */
package io.appform.idman.authcomponents.resource;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.appform.idman.authcomponents.security.ServiceUserPrincipal;
import io.appform.idman.client.IdManClient;
import io.appform.idman.client.IdmanClientConfig;
import io.appform.idman.model.TokenInfo;
import io.dropwizard.auth.Auth;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/idman/auth")
public class IdmanAuthHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdmanAuthHandler.class);
    private static final String IDMAN_STATE_COOKIE_NAME = "idman-auth-state";
    private static final String IDMAN_LOCAL_REDIRECT = "idman-local-redirect";
    private static final String IDMAN_TOKEN_COOKIE_NAME = "idman-token";
    private static final String AUTH_API = "/idman/auth";
    private final IdManClient idManClient;
    private final IdmanClientConfig config;

    @Inject
    public IdmanAuthHandler(IdManClient idManClient, IdmanClientConfig config) {
        this.idManClient = idManClient;
        this.config = config;
    }

    @GET
    public Response startAuth(@HeaderParam(value="Referer") String referrer, @CookieParam(value="idman-local-redirect") Cookie localRedirect, @QueryParam(value="error") String error) {
        String callbackPath = this.prefixedPath("/idman/auth/callback");
        String clientAuthSessionId = UUID.randomUUID().toString();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.config.getAuthEndpoint() + "/apis/oauth2/authorize")).queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{this.config.getServiceId()}).queryParam("redirect_uri", new Object[]{URI.create(callbackPath)}).queryParam("state", new Object[]{clientAuthSessionId});
        if (!Strings.isNullOrEmpty((String)error)) {
            uriBuilder.queryParam("error", new Object[]{error});
        }
        URI idmanUri = uriBuilder.build(new Object[0]);
        String finalRedirect = null != localRedirect ? localRedirect.getValue() : referrer;
        log.debug("Final Redirect: {}", (Object)finalRedirect);
        return Response.seeOther((URI)idmanUri).cookie(new NewCookie[]{new NewCookie(IDMAN_LOCAL_REDIRECT, finalRedirect, callbackPath, null, 1, null, -1, null, false, true)}).cookie(new NewCookie[]{new NewCookie(IDMAN_STATE_COOKIE_NAME, clientAuthSessionId, callbackPath, null, 1, null, -1, null, false, true)}).build();
    }

    @GET
    @Path(value="/callback")
    @Produces(value={"application/json"})
    public Response handleCallback(@CookieParam(value="idman-auth-state") Cookie cookieState, @CookieParam(value="idman-local-redirect") Cookie localRedirect, @QueryParam(value="state") String clientSessionId, @QueryParam(value="code") String code, @QueryParam(value="error") String errorCode, @QueryParam(value="error_description") String errorDescription) {
        if (!Strings.isNullOrEmpty((String)errorCode)) {
            return Response.ok((Object)ImmutableMap.of((Object)"errorCode", (Object)errorCode, (Object)"errorDescription", (Object)errorDescription)).build();
        }
        if (null == cookieState || null == localRedirect) {
            log.error("Missing cookie params for callback");
            return Response.seeOther((URI)URI.create(this.prefixedPath(AUTH_API))).build();
        }
        if (!cookieState.getValue().equals(clientSessionId)) {
            log.error("State cookie mismatch. Expected: {} Received callback for: {}", (Object)cookieState.getValue(), (Object)clientSessionId);
            return Response.seeOther((URI)URI.create(this.prefixedPath(AUTH_API))).build();
        }
        TokenInfo tokenInfo = this.idManClient.accessToken(this.config.getServiceId(), code).orElse(null);
        if (null == tokenInfo) {
            log.error("Token validation failed. Token: {}", (Object)code);
            return Response.seeOther((URI)URI.create(this.prefixedPath(AUTH_API))).build();
        }
        String localRedirectPath = Strings.isNullOrEmpty((String)localRedirect.getValue()) ? this.config.getPublicEndpoint() : localRedirect.getValue();
        log.debug("Redirecting to: {}. Local redirect: {}", (Object)localRedirectPath, (Object)localRedirect.getValue());
        return Response.seeOther((URI)URI.create(localRedirectPath)).cookie(new NewCookie[]{new NewCookie(this.cookieName(), tokenInfo.getAccessToken(), "/", null, 1, null, -1, null, false, true), this.expireCookie(cookieState), this.expireCookie(localRedirect)}).build();
    }

    @Path(value="/logout")
    @POST
    @PermitAll
    public Response logout(@Auth ServiceUserPrincipal principal, @Context HttpServletRequest requestContext) {
        String sessionId = principal.getServiceUser().getSessionId();
        log.debug("Logging out session: {}", (Object)sessionId);
        String cookieName = this.cookieName();
        String token = Optional.ofNullable(requestContext.getCookies()).flatMap(cookies -> Arrays.stream(cookies).filter(c -> c.getName().equals(cookieName)).findAny().map(javax.servlet.http.Cookie::getValue)).orElse(null);
        if (!Strings.isNullOrEmpty((String)token)) {
            boolean status = this.idManClient.deleteToken(this.config.getServiceId(), token);
            log.info("Session {} deletion status for user {}: {}", new Object[]{sessionId, principal.getServiceUser().getUser().getId(), status});
        }
        return Response.seeOther((URI)URI.create(this.config.getPublicEndpoint())).cookie(new NewCookie[]{new NewCookie(cookieName, "", "/", null, 1, null, -1, null, false, true)}).build();
    }

    private String prefixedPath(String path) {
        return this.config.getPublicEndpoint() + (!Strings.isNullOrEmpty((String)this.config.getResourcePrefix()) ? this.config.getResourcePrefix() : "") + path;
    }

    private String cookieName() {
        return "idman-token-" + this.config.getServiceId().toLowerCase();
    }

    private NewCookie expireCookie(Cookie cookie) {
        return new NewCookie(cookie, null, 0, null, false, true);
    }
}

