/*
 * Decompiled with CFR 0.152.
 */
package io.appform.idman.authcomponents.filters;

import com.google.common.base.Strings;
import io.appform.idman.authcomponents.security.ServiceUserPrincipal;
import io.appform.idman.client.IdmanClientConfig;
import io.dropwizard.auth.AuthFilter;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public class IdmanAuthFilter
extends AuthFilter<String, ServiceUserPrincipal> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdmanAuthFilter.class);
    private static final String ERROR_PARAM = "error";
    private final IdmanClientConfig config;

    public IdmanAuthFilter(IdmanClientConfig config) {
        this.config = config;
    }

    public void filter(ContainerRequestContext requestContext) {
        UriInfo uriInfo = requestContext.getUriInfo();
        String requestURI = uriInfo.getPath(true);
        if (this.config.getAllowedPaths().stream().anyMatch(requestURI::startsWith)) {
            return;
        }
        String jwt = this.getTokenFromCookieOrHeader(requestContext).orElse(null);
        if (!this.authenticate(requestContext, jwt, "FORM")) {
            MultivaluedMap params = uriInfo.getQueryParameters(true);
            UriBuilder uriBuilder = UriBuilder.fromUri((URI)URI.create(this.config.getPublicEndpoint() + (!Strings.isNullOrEmpty((String)this.config.getResourcePrefix()) ? this.config.getResourcePrefix() : "") + "/idman/auth"));
            if (params.containsKey((Object)ERROR_PARAM)) {
                uriBuilder.queryParam(ERROR_PARAM, new Object[]{params.getFirst((Object)ERROR_PARAM)});
            }
            throw new WebApplicationException(Response.seeOther((URI)uriBuilder.build(new Object[0])).build());
        }
        log.debug("Auth successful");
    }

    private Optional<String> getTokenFromCookieOrHeader(ContainerRequestContext requestContext) {
        Optional<String> tokenFromHeader = this.getTokenFromHeader(requestContext);
        return tokenFromHeader.isPresent() ? tokenFromHeader : this.getTokenFromCookie(requestContext);
    }

    private Optional<String> getTokenFromHeader(ContainerRequestContext requestContext) {
        String method;
        int space;
        String header = (String)requestContext.getHeaders().getFirst((Object)"Authorization");
        if (header != null && (space = header.indexOf(32)) > 0 && "Bearer".equalsIgnoreCase(method = header.substring(0, space))) {
            String rawToken = header.substring(space + 1);
            return Optional.of(rawToken);
        }
        return Optional.empty();
    }

    private Optional<String> getTokenFromCookie(ContainerRequestContext requestContext) {
        Cookie idmanCookie = (Cookie)requestContext.getCookies().get("idman-token-" + this.config.getServiceId().toLowerCase());
        if (null != idmanCookie) {
            return Optional.of(idmanCookie.getValue());
        }
        return Optional.empty();
    }

    public static class Builder
    extends AuthFilter.AuthFilterBuilder<String, ServiceUserPrincipal, IdmanAuthFilter> {
        private final IdmanClientConfig authenticationConfig;

        public Builder(IdmanClientConfig authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
        }

        protected IdmanAuthFilter newInstance() {
            return new IdmanAuthFilter(this.authenticationConfig);
        }
    }
}

