/*
 * Decompiled with CFR 0.152.
 */
package io.appform.idman.authcomponents;

import com.github.benmanes.caffeine.cache.CaffeineSpec;
import io.appform.idman.authcomponents.filters.IdmanAuthFilter;
import io.appform.idman.authcomponents.security.IdmanAuthenticator;
import io.appform.idman.authcomponents.security.IdmanRoleAuthorizer;
import io.appform.idman.authcomponents.security.RedirectUnauthorizedHandler;
import io.appform.idman.authcomponents.security.ServiceUserPrincipal;
import io.appform.idman.client.IdManClient;
import io.appform.idman.client.IdmanClientConfig;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.auth.CachingAuthorizer;
import io.dropwizard.auth.UnauthorizedHandler;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.setup.Environment;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import lombok.Generated;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class IdmanAuthDynamicFeature
extends AuthDynamicFeature {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdmanAuthDynamicFeature.class);

    @Inject
    public IdmanAuthDynamicFeature(Environment environment, IdmanClientConfig authConfig, IdManClient idManClient) {
        super((ContainerRequestFilter)new IdmanAuthFilter.Builder(authConfig).setAuthenticator(new IdmanAuthenticator(authConfig, idManClient)).setAuthorizer((Authorizer)new CachingAuthorizer(environment.metrics(), (Authorizer)new IdmanRoleAuthorizer(), CaffeineSpec.parse((String)authConfig.getCacheSpec()))).setUnauthorizedHandler((UnauthorizedHandler)new RedirectUnauthorizedHandler(authConfig)).buildAuthFilter());
        JerseyEnvironment jersey = environment.jersey();
        if (null != jersey) {
            jersey.register((Object)new AuthValueFactoryProvider.Binder(ServiceUserPrincipal.class));
            jersey.register(RolesAllowedDynamicFeature.class);
        } else {
            log.warn("No jersey container. Skipped adding stuff");
        }
        log.info("IDMan dynamic feature enabled");
    }
}

