/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.functions.impl.pointer;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import io.appform.hope.core.Value;
import io.appform.hope.core.functions.FunctionImplementation;
import io.appform.hope.core.functions.HopeFunction;
import io.appform.hope.core.utils.Converters;
import io.appform.hope.core.values.BooleanValue;
import io.appform.hope.core.visitors.Evaluator;

@FunctionImplementation(value="pointer.exists")
public class Exists
extends HopeFunction<BooleanValue> {
    private final Value pointer;

    public Exists(Value pointer) {
        this.pointer = pointer;
    }

    @Override
    public BooleanValue apply(Evaluator.EvaluationContext evaluationContext) {
        String pathValue = Converters.jsonPointerValue(evaluationContext, this.pointer, "");
        if (Strings.isNullOrEmpty((String)pathValue)) {
            return new BooleanValue(false);
        }
        JsonNode node = evaluationContext.getRootNode().at(pathValue);
        if (null == node || node.isNull() || node.isMissingNode()) {
            return new BooleanValue(false);
        }
        return new BooleanValue(true);
    }
}

